/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.traits.TraitManager;

public class LazyTraitInstance
implements ITraitInstance {
    private final ResourceLocation traitId;
    private final int level;
    private final ImmutableList<ITraitCondition> conditions;

    LazyTraitInstance(ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        this.traitId = traitId;
        this.level = level;
        this.conditions = ImmutableList.builder().add((Object[])conditions).build();
    }

    @Override
    public ResourceLocation getTraitId() {
        return this.traitId;
    }

    @Override
    @Nullable
    public ITrait getTrait() {
        return TraitManager.get(this.traitId);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public ImmutableList<ITraitCondition> getConditions() {
        return this.conditions;
    }
}

