/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;

public class StatModifierMap
implements Multimap<IItemStat, StatInstance> {
    private final Multimap<IItemStat, StatInstance> map = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    public static ITextComponent formatText(Collection<StatInstance> mods, ItemStat stat, int maxDecimalPlaces) {
        if (mods.size() == 1) {
            StatInstance inst2 = mods.iterator().next();
            int decimalPlaces = inst2.getPreferredDecimalPlaces(stat, maxDecimalPlaces);
            return new StringTextComponent(inst2.formattedString(stat, decimalPlaces, false));
        }
        StringBuilder result = new StringBuilder();
        mods.forEach(inst -> {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(inst.formattedString(stat, inst.getPreferredDecimalPlaces(stat, maxDecimalPlaces), false));
        });
        return new StringTextComponent(result.toString());
    }

    public Set<ItemStat> getStats() {
        return this.keySet().stream().filter(s -> s instanceof ItemStat).map(s -> (ItemStat)s).collect(Collectors.toSet());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.map.containsEntry(key, value);
    }

    public boolean put(IItemStat key, StatInstance value) {
        return this.map.put((Object)key, (Object)value);
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    public boolean putAll(IItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.putAll((Object)key, values);
    }

    public boolean putAll(@Nonnull Multimap<? extends IItemStat, ? extends StatInstance> multimap) {
        return this.map.putAll(multimap);
    }

    public Collection<StatInstance> replaceValues(IItemStat key, @Nonnull Iterable<? extends StatInstance> values) {
        return this.map.replaceValues((Object)key, values);
    }

    public Collection<StatInstance> removeAll(Object key) {
        return this.map.removeAll(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<StatInstance> get(IItemStat key) {
        return this.map.get((Object)key);
    }

    public Set<IItemStat> keySet() {
        return this.map.keySet();
    }

    public Multiset<IItemStat> keys() {
        return this.map.keys();
    }

    public Collection<StatInstance> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<IItemStat, StatInstance>> entries() {
        return this.map.entries();
    }

    public Map<IItemStat, Collection<StatInstance>> asMap() {
        return this.map.asMap();
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        for (IItemStat stat : this.keySet()) {
            Collection<StatInstance> mods = this.get(stat);
            String shortStatId = SilentGear.shortenId(stat.getStatId());
            if (mods.size() > 1) {
                JsonArray array = new JsonArray();
                mods.forEach(mod -> array.add(mod.serialize(stat)));
                json.add(shortStatId, (JsonElement)array);
                continue;
            }
            if (mods.size() != 1) continue;
            json.add(shortStatId, mods.iterator().next().serialize(stat));
        }
        return json;
    }

    @Deprecated
    public static StatModifierMap read(IGearPart part, JsonElement json) {
        return StatModifierMap.read(json);
    }

    public static StatModifierMap read(JsonElement json) {
        StatModifierMap map = new StatModifierMap();
        if (json.isJsonObject()) {
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                ItemStat stat = ItemStats.byName((String)entry.getKey());
                if (stat == null) continue;
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonArray()) {
                    value.getAsJsonArray().forEach(e -> map.put(stat, StatInstance.read(stat, e)));
                    continue;
                }
                map.put(stat, StatInstance.read(stat, value));
            }
        } else if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                JsonObject jsonObj = element.getAsJsonObject();
                ItemStat stat = ItemStats.byName(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"name"));
                if (stat == null) continue;
                map.put(stat, StatInstance.read(stat, element));
            }
        } else {
            throw new JsonParseException("Expected object or array");
        }
        return map;
    }

    public static StatModifierMap read(PacketBuffer buffer) {
        StatModifierMap map = new StatModifierMap();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            ItemStat stat = (ItemStat)((IForgeRegistry)ItemStats.REGISTRY.get()).getValue(buffer.func_192575_l());
            StatInstance instance = StatInstance.read(buffer);
            map.put(stat, instance);
        }
        return map;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.size());
        this.forEach((stat, instance) -> {
            buffer.func_192572_a(stat.getStatId());
            instance.write(buffer);
        });
    }
}

