/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.utils.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;

public class StatInstance {
    public static final StatInstance ZERO = new StatInstance(0.0f, Operation.ADD);
    private static final Pattern REGEX_TRIM_TO_INT = Pattern.compile("\\.0+$");
    private static final Pattern REGEX_REMOVE_TRAILING_ZEROS = Pattern.compile("0+$");
    private final float value;
    private final Operation op;

    public StatInstance copySetValue(float v) {
        return new StatInstance(v, this.op);
    }

    @Deprecated
    public StatInstance(String id, float value, Operation op) {
        this.value = value;
        this.op = op;
    }

    public StatInstance(float value, Operation op) {
        this.value = value;
        this.op = op;
    }

    public StatInstance copy() {
        return new StatInstance(this.value, this.op);
    }

    @Deprecated
    public String getId() {
        return "DEPRECATED";
    }

    public float getValue() {
        return this.value;
    }

    public Operation getOp() {
        return this.op;
    }

    public static StatInstance makeBaseMod(float value) {
        return new StatInstance("_base_mod", value, Operation.ADD);
    }

    public static StatInstance makeGearMod(float multi) {
        return new StatInstance("_gear_mod", multi, Operation.MUL1);
    }

    public static StatInstance getWeightedAverageMod(Collection<StatInstance> modifiers, Operation op) {
        return new StatInstance(ItemStat.getWeightedAverage(modifiers, op), op);
    }

    @Deprecated
    public StatInstance copyAppendId(String append) {
        return this.copyWithNewId(this.getId() + append);
    }

    @Deprecated
    public StatInstance copyWithNewId(String newId) {
        return new StatInstance(newId, this.value, this.op);
    }

    public String formattedString(ItemStat stat, @Nonnegative int decimalPlaces, boolean addColor) {
        String format = "%s" + "%." + decimalPlaces + "f" + "%s";
        switch (this.op) {
            case ADD: {
                TextFormatting color = this.getFormattedColor(this.value, 0.0f, addColor);
                return StatInstance.trimNumber(color + String.format(format, this.value < 0.0f ? "" : "+", Float.valueOf(this.value), ""));
            }
            case AVG: {
                if (stat.getDisplayFormat() == ItemStat.DisplayFormat.PERCENTAGE) {
                    return Math.round((1.0f + this.value) * 100.0f) + "%";
                }
                String ret = StatInstance.trimNumber(String.format(format, "", Float.valueOf(this.value), ""));
                return stat.getDisplayFormat() == ItemStat.DisplayFormat.MULTIPLIER ? ret + "x" : ret;
            }
            case MAX: {
                return StatInstance.trimNumber(String.format(format, "^", Float.valueOf(this.value), ""));
            }
            case MUL1: {
                int percent = Math.round(100.0f * this.value);
                TextFormatting color = this.getFormattedColor(percent, 0.0f, addColor);
                return StatInstance.trimNumber(color + String.format("%s%d%%", percent < 0 ? "" : "+", percent));
            }
            case MUL2: {
                float val = 1.0f + this.value;
                TextFormatting color = this.getFormattedColor(val, 1.0f, addColor);
                return StatInstance.trimNumber(color + String.format(format, "x", Float.valueOf(val), ""));
            }
        }
        throw new NotImplementedException("Unknown operation: " + (Object)((Object)this.op));
    }

    private static String trimNumber(CharSequence str) {
        String trimToInt = REGEX_TRIM_TO_INT.matcher(str).replaceFirst("");
        if (trimToInt.contains(".")) {
            return REGEX_REMOVE_TRAILING_ZEROS.matcher(trimToInt).replaceFirst("");
        }
        return trimToInt;
    }

    private TextFormatting getFormattedColor(float val, float whiteVal, boolean addColor) {
        if (!addColor) {
            return TextFormatting.WHITE;
        }
        return val < whiteVal ? TextFormatting.RED : (val == whiteVal ? TextFormatting.WHITE : TextFormatting.GREEN);
    }

    public boolean shouldList(IGearPart part, ItemStat stat, boolean advanced) {
        return this.shouldList(part.getType(), stat, advanced);
    }

    public boolean shouldList(PartType partType, ItemStat stat, boolean advanced) {
        return advanced || this.value != 0.0f || partType == PartType.MAIN && stat == ItemStats.HARVEST_LEVEL;
    }

    public int getPreferredDecimalPlaces(ItemStat stat, int max) {
        return stat.isDisplayAsInt() && this.op != Operation.MUL1 && this.op != Operation.MUL2 ? 0 : 2;
    }

    public String toString() {
        return String.format("StatInstance{value=%f, op=%s}", new Object[]{Float.valueOf(this.value), this.op});
    }

    public JsonElement serialize(IItemStat stat) {
        if (this.op == Operation.AVG) {
            return new JsonPrimitive((Number)Float.valueOf(this.value));
        }
        JsonObject json = new JsonObject();
        json.addProperty(this.op.name().toLowerCase(Locale.ROOT), (Number)Float.valueOf(this.value));
        return json;
    }

    public static StatInstance read(ItemStat stat, JsonElement json) {
        return StatInstance.read(stat, stat.getDefaultOperation(), json);
    }

    public static StatInstance read(ItemStat stat, Operation defaultOp, JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new StatInstance(json.getAsFloat(), defaultOp);
        }
        if (json.isJsonObject()) {
            JsonObject jsonObj = json.getAsJsonObject();
            StatInstance result = StatInstance.readShorthandObject(stat, jsonObj);
            if (result != null) {
                return result;
            }
            float value = JSONUtils.func_151221_a((JsonObject)jsonObj, (String)"value", (float)0.0f);
            Operation op = jsonObj.has("op") ? Operation.byName(JSONUtils.func_151200_h((JsonObject)jsonObj, (String)"op")) : defaultOp;
            return new StatInstance(value, op);
        }
        throw new JsonParseException("Expected stat modifier JSON to be float or object");
    }

    @Nullable
    private static StatInstance readShorthandObject(ItemStat stat, JsonObject json) {
        StatInstance result = null;
        for (Map.Entry entry : json.entrySet()) {
            Operation op = Operation.byNameOrNull((String)entry.getKey());
            if (op == null) continue;
            if (result == null) {
                result = new StatInstance(((JsonElement)entry.getValue()).getAsFloat(), op);
                continue;
            }
            throw new JsonParseException("Found multiple op keys in stat modifier object");
        }
        return result;
    }

    @Deprecated
    public static StatInstance read(String id, PacketBuffer buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)Operation.AVG);
        return new StatInstance(id, value, op);
    }

    public static StatInstance read(PacketBuffer buffer) {
        float value = buffer.readFloat();
        Operation op = (Operation)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)Operation.AVG);
        return new StatInstance(value, op);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeFloat(this.value);
        buffer.writeByte(this.op.ordinal());
    }

    public static enum Operation {
        AVG,
        ADD,
        MUL1,
        MUL2,
        MAX;


        public static Operation byName(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return AVG;
        }

        @Nullable
        public static Operation byNameOrNull(String str) {
            for (Operation op : Operation.values()) {
                if (!op.name().equalsIgnoreCase(str)) continue;
                return op;
            }
            return null;
        }
    }
}

