/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.stats;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;

@ParametersAreNonnullByDefault
public class ItemStat
extends ForgeRegistryEntry<ItemStat>
implements IItemStat {
    private final float defaultValue;
    private final float minimumValue;
    private final float maximumValue;
    private final StatInstance.Operation defaultOperation;
    private final TextFormatting nameColor;
    private final boolean visible;
    private final boolean synergyApplies;
    private final boolean affectedByGrades;
    private final boolean displayAsInt;
    private final DisplayFormat displayFormat;
    private final Function<Float, Float> missingRodFunction;
    private static final float WEIGHT_BASE_MIN = 2.0f;
    private static final float WEIGHT_BASE_MAX = 40.0f;
    private static final float WEIGHT_DEVIATION_COEFF = 2.0f;

    public ItemStat(float defaultValue, float minValue, float maxValue, TextFormatting nameColor, Properties properties) {
        this.defaultValue = defaultValue;
        this.minimumValue = minValue;
        this.maximumValue = maxValue;
        this.nameColor = nameColor;
        this.defaultOperation = properties.defaultOp;
        this.displayAsInt = properties.displayAsInt;
        this.displayFormat = properties.displayFormat;
        this.visible = properties.visible;
        this.synergyApplies = properties.synergyApplies;
        this.affectedByGrades = properties.affectedByGrades;
        this.missingRodFunction = properties.missingRodFunction;
        if (this.minimumValue > this.maximumValue) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (this.defaultValue < this.minimumValue) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (this.defaultValue > this.maximumValue) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
        ItemStats.STATS_IN_ORDER.add(this);
    }

    @Deprecated
    public ResourceLocation getName() {
        return this.getRegistryName();
    }

    @Override
    public ResourceLocation getStatId() {
        return this.getRegistryName();
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getMinimumValue() {
        return this.minimumValue;
    }

    public float getMaximumValue() {
        return this.maximumValue;
    }

    public StatInstance.Operation getDefaultOperation() {
        return this.defaultOperation;
    }

    public boolean isDisplayAsInt() {
        return this.displayAsInt;
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    @Deprecated
    public boolean isDisplayAsMultiplier() {
        return this.displayFormat == DisplayFormat.MULTIPLIER;
    }

    public TextFormatting getNameColor() {
        return this.nameColor;
    }

    public float clampValue(float value) {
        value = MathHelper.func_76131_a((float)value, (float)this.minimumValue, (float)this.maximumValue);
        return value;
    }

    public float compute(float baseValue, Collection<StatInstance> modifiers) {
        return this.compute(baseValue, true, modifiers);
    }

    public float compute(float baseValue, boolean clampValue, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return baseValue;
        }
        float f0 = baseValue;
        f0 += ItemStat.getWeightedAverage(modifiers, StatInstance.Operation.AVG);
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MAX) continue;
            f0 = Math.max(f0, mod.getValue());
        }
        float f1 = f0;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL1) continue;
            f1 += f0 * mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.MUL2) continue;
            f1 *= 1.0f + mod.getValue();
        }
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != StatInstance.Operation.ADD) continue;
            f1 += mod.getValue();
        }
        return clampValue ? this.clampValue(f1) : f1;
    }

    private static float getPrimaryMod(Iterable<StatInstance> modifiers, StatInstance.Operation op) {
        float primaryMod = -1.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op || !(primaryMod < 0.0f)) continue;
            primaryMod = mod.getValue();
        }
        return primaryMod > 0.0f ? primaryMod : 1.0f;
    }

    public static float getWeightedAverage(Collection<StatInstance> modifiers, StatInstance.Operation op) {
        float primaryMod = ItemStat.getPrimaryMod(modifiers, op);
        float ret = 0.0f;
        int count = 0;
        float totalWeight = 0.0f;
        for (StatInstance mod : modifiers) {
            if (mod.getOp() != op) continue;
            float weight = ItemStat.getModifierWeight(mod, primaryMod, ++count);
            totalWeight += weight;
            ret += mod.getValue() * weight;
        }
        return count > 0 ? ret / totalWeight : ret;
    }

    private static float getModifierWeight(StatInstance mod, float primaryMod, int count) {
        float weightBase = 2.0f + 2.0f * (mod.getValue() - primaryMod) / primaryMod;
        float weightBaseClamped = MathHelper.func_76131_a((float)weightBase, (float)2.0f, (float)40.0f);
        return (float)Math.pow(weightBaseClamped, -(count == 0 ? (double)count : 0.5 + (double)(0.5f * (float)count)));
    }

    @Deprecated
    public StatInstance computeForDisplay(float baseValue, MaterialGrade grade, Collection<StatInstance> modifiers) {
        return this.computeForDisplay(baseValue, modifiers);
    }

    public StatInstance computeForDisplay(float baseValue, Collection<StatInstance> modifiers) {
        if (modifiers.isEmpty()) {
            return new StatInstance(baseValue, StatInstance.Operation.AVG);
        }
        boolean add = true;
        for (StatInstance inst : modifiers) {
            StatInstance.Operation op = inst.getOp();
            if (op != StatInstance.Operation.AVG && op != StatInstance.Operation.ADD && op != StatInstance.Operation.MAX) continue;
            add = false;
            break;
        }
        float value = this.compute(baseValue + (float)add, false, modifiers) - (float)add;
        StatInstance.Operation op = modifiers.iterator().next().getOp();
        return new StatInstance(value, op);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean doesSynergyApply() {
        return this.synergyApplies;
    }

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    public float withMissingRodEffect(float statValue) {
        if (this.missingRodFunction == null) {
            return statValue;
        }
        return this.missingRodFunction.apply(Float.valueOf(statValue)).floatValue();
    }

    public String toString() {
        return String.format("ItemStat{%s, default=%.2f, min=%.2f, max=%.2f}", this.getRegistryName(), Float.valueOf(this.defaultValue), Float.valueOf(this.minimumValue), Float.valueOf(this.maximumValue));
    }

    public ITextComponent getDisplayName() {
        ResourceLocation name = this.getRegistryName();
        if (name == null) {
            return new StringTextComponent("Unregistered stat: " + this);
        }
        return new TranslationTextComponent("stat." + name.func_110624_b() + "." + name.func_110623_a(), new Object[0]);
    }

    public static class Properties {
        private StatInstance.Operation defaultOp = StatInstance.Operation.AVG;
        private boolean displayAsInt;
        private DisplayFormat displayFormat = DisplayFormat.UNIT;
        private boolean visible = true;
        private boolean synergyApplies = false;
        private boolean affectedByGrades = true;
        private Function<Float, Float> missingRodFunction;

        public Properties defaultOp(StatInstance.Operation op) {
            this.defaultOp = op;
            return this;
        }

        public Properties displayAsInt() {
            this.displayAsInt = true;
            return this;
        }

        public Properties displayFormat(DisplayFormat format) {
            this.displayFormat = format;
            return this;
        }

        @Deprecated
        public Properties displayAsMultiplier() {
            this.displayFormat = DisplayFormat.MULTIPLIER;
            return this;
        }

        public Properties hidden() {
            this.visible = false;
            return this;
        }

        public Properties synergyApplies() {
            this.synergyApplies = true;
            return this;
        }

        public Properties affectedByGrades(boolean value) {
            this.affectedByGrades = value;
            return this;
        }

        public Properties missingRodFunction(Function<Float, Float> function) {
            this.missingRodFunction = function;
            return this;
        }
    }

    public static enum DisplayFormat {
        UNIT,
        MULTIPLIER,
        PERCENTAGE;

    }
}

