/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitConditionSerializer;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.traits.TraitManager;

public class PartTraitInstance {
    private final ITrait trait;
    private final int level;
    private final List<ITraitCondition> conditions;

    public PartTraitInstance(ITrait trait, int level, Collection<ITraitCondition> conditions) {
        this.trait = trait;
        this.level = level;
        this.conditions = ImmutableList.copyOf(conditions);
    }

    public ITrait getTrait() {
        return this.trait;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean conditionsMatch(PartDataList parts, ItemStack gear) {
        return this.conditions.stream().allMatch(c -> c.matches(gear, parts, this.trait));
    }

    public boolean conditionsMatch(Collection<MaterialInstance> materials, PartType partType, ItemStack gear) {
        return this.conditions.stream().allMatch(c -> c.matches(gear, partType, materials, this.trait));
    }

    public ITextComponent getDisplayName() {
        ITextComponent text = this.trait.getDisplayName(this.level);
        if (!this.conditions.isEmpty()) {
            text.func_150257_a((ITextComponent)new StringTextComponent("*"));
        }
        return text;
    }

    public void addInformation(List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!this.trait.showInTooltip(flag)) {
            return;
        }
        ITextComponent displayName = this.getDisplayName().func_211708_a(TextFormatting.ITALIC);
        if (this.trait.isHidden()) {
            displayName.func_211708_a(TextFormatting.DARK_GRAY);
        }
        tooltip.add(displayName);
        if (KeyTracker.isAltDown()) {
            ITextComponent description = this.trait.getDescription(this.level).func_211708_a(TextFormatting.DARK_GRAY);
            tooltip.add(new StringTextComponent("  ").func_150257_a(description));
        }
    }

    public static PartTraitInstance deserialize(JsonObject json) {
        ResourceLocation traitId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            throw new JsonSyntaxException("Unknown trait: " + traitId);
        }
        int level = MathHelper.func_76125_a((int)JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1), (int)1, (int)trait.getMaxLevel());
        ArrayList<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
        if (json.has("conditions")) {
            JsonArray array = json.getAsJsonArray("conditions");
            for (JsonElement j : array) {
                conditions.add(ITraitConditionSerializer.getCondition(j.getAsJsonObject()));
            }
        }
        return new PartTraitInstance(trait, level, conditions);
    }

    public static PartTraitInstance read(PacketBuffer buffer) {
        ResourceLocation traitId = buffer.func_192575_l();
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            throw new IllegalStateException("Unknown trait: " + traitId);
        }
        byte level = buffer.readByte();
        return new PartTraitInstance(trait, level, (Collection<ITraitCondition>)ImmutableList.of());
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.trait.getId());
        buffer.writeByte(this.level);
    }
}

