/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.util.TextUtil;

public interface IMaterialInstance {
    public ResourceLocation getMaterialId();

    @Nullable
    public IMaterial getMaterial();

    public MaterialGrade getGrade();

    public ItemStack getItem();

    public int getTier(PartType var1);

    default public float getStat(ItemStat stat, PartType partType) {
        return this.getStat(stat, partType, ItemStack.field_190927_a);
    }

    public float getStat(ItemStat var1, PartType var2, ItemStack var3);

    public CompoundNBT write(CompoundNBT var1);

    @Deprecated
    public int getColor(PartType var1, ItemStack var2);

    @Deprecated
    default public int getColor(PartType partType) {
        return this.getColor(partType, ItemStack.field_190927_a);
    }

    public ITextComponent getDisplayName(PartType var1, ItemStack var2);

    default public ITextComponent getDisplayName(PartType partType) {
        return this.getDisplayName(partType, ItemStack.field_190927_a);
    }

    default public ITextComponent getDisplayNameWithGrade(PartType partType) {
        ITextComponent gradeSuffix = TextUtil.translate("misc", "spaceBrackets", this.getGrade().getDisplayName());
        return this.getDisplayName(partType, ItemStack.field_190927_a).func_150257_a(gradeSuffix);
    }

    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("material", this.getMaterialId().toString());
        MaterialGrade grade = this.getGrade();
        if (grade != MaterialGrade.NONE) {
            json.addProperty("grade", grade.name());
        }
        return json;
    }

    public void write(PacketBuffer var1);
}

