/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.ColorHandlers;

public interface ICoreTool
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object)ItemStats.DURABILITY, (Object)ItemStats.ENCHANTABILITY, (Object[])new ItemStat[]{ItemStats.RARITY});
    public static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.ARMOR_DURABILITY, (Object)ItemStats.ARMOR, (Object)ItemStats.ARMOR_TOUGHNESS, (Object)ItemStats.MAGIC_ARMOR);

    @Override
    default public Set<ItemStat> getRelevantStats(@Nonnull ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    default public Collection<PartType> getRequiredParts() {
        return ImmutableList.of((Object)PartType.MAIN, (Object)PartType.ROD);
    }

    default public int getDamageOnBlockBreak(ItemStack gear, World world, BlockState state, BlockPos pos) {
        return state.func_185904_a() != Material.field_151584_j && state.func_185887_b((IBlockReader)world, pos) > 0.0f ? 1 : 0;
    }

    default public int getDamageOnHitEntity(ItemStack gear, LivingEntity target, LivingEntity attacker) {
        return 2;
    }

    @Override
    default public IItemColor getItemColors() {
        return ColorHandlers::getToolColor;
    }

    @Override
    default public boolean hasTexturesFor(PartType partType) {
        return partType != PartType.BOWSTRING && partType != PartType.FLETCHING;
    }
}

