/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.IStatItem;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;

public interface ICoreItem
extends IItemProvider,
IStatItem {
    default public ItemStack construct(Collection<? extends IPartData> parts) {
        ItemStack result = new ItemStack((IItemProvider)this);
        GearData.writeConstructionParts(result, parts);
        parts.forEach(p -> p.onAddToGear(result));
        GearData.recalculateStats(result, null);
        TraitHelper.activateTraits(result, 0.0f, (trait, level, nothing) -> {
            trait.onGearCrafted(new TraitActionContext(null, level, result));
            return 0.0f;
        });
        return result;
    }

    default public Item func_199767_j() {
        return (Item)this;
    }

    public GearType getGearType();

    default public boolean requiresPartOfType(PartType type) {
        return this.getRequiredParts().contains(type);
    }

    default public boolean supportsPart(ItemStack gear, PartData part) {
        boolean canAdd = part.getPart().canAddToGear(gear, part);
        return this.requiresPartOfType(part.getType()) && canAdd || canAdd;
    }

    default public Collection<PartType> getRequiredParts() {
        return ImmutableList.of((Object)PartType.MAIN);
    }

    @Override
    default public float getStat(ItemStack stack, ItemStat stat) {
        return GearData.getStat(stack, stat);
    }

    public Set<ItemStat> getRelevantStats(ItemStack var1);

    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return Collections.emptySet();
    }

    default public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    default public Optional<StatInstance> getStatModifier(ItemStat stat) {
        return Optional.empty();
    }

    default public ItemStat getDurabilityStat() {
        return ItemStats.DURABILITY;
    }

    default public float getRepairModifier(ItemStack stack) {
        return 1.0f;
    }

    default public int getAnimationFrames() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getAnimationFrame(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public IItemColor getItemColors() {
        return (stack, tintIndex) -> 0xFFFFFF;
    }

    default public boolean hasTexturesFor(PartType partType) {
        return true;
    }
}

