/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="aquaculture")
public class AquaLootTables {
    public static final ResourceLocation BOX = AquaLootTables.register("box/box");
    public static final ResourceLocation LOCKBOX = AquaLootTables.register("box/lockbox");
    public static final ResourceLocation TREASURE_CHEST = AquaLootTables.register("box/treasure_chest");
    public static final ResourceLocation NEPTUNES_BOUNTY = AquaLootTables.register("box/neptunes_bounty");
    public static final ResourceLocation FISH = AquaLootTables.register("gameplay/fishing/fish");
    public static final ResourceLocation JUNK = AquaLootTables.register("gameplay/fishing/junk");
    public static final ResourceLocation NEPTUNIUM = AquaLootTables.register("gameplay/fishing/neptunium");
    public static final ResourceLocation LAVA_FISHING = AquaLootTables.register("gameplay/fishing/lava/fishing");
    public static final ResourceLocation LAVA_FISH = AquaLootTables.register("gameplay/fishing/lava/fish");
    public static final ResourceLocation LAVA_JUNK = AquaLootTables.register("gameplay/fishing/lava/junk");
    public static final ResourceLocation LAVA_TREASURE = AquaLootTables.register("gameplay/fishing/lava/treasure");
    public static final ResourceLocation NETHER_FISHING = AquaLootTables.register("gameplay/fishing/nether/fishing");
    public static final ResourceLocation NETHER_FISH = AquaLootTables.register("gameplay/fishing/nether/fish");
    public static final ResourceLocation NETHER_JUNK = AquaLootTables.register("gameplay/fishing/nether/junk");
    public static final ResourceLocation NETHER_TREASURE = AquaLootTables.register("gameplay/fishing/nether/treasure");

    private static ResourceLocation register(String path) {
        return LootTables.func_186375_a((ResourceLocation)new ResourceLocation("aquaculture", path));
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        ResourceLocation name = event.getName();
        if (name.equals((Object)LootTables.field_186387_al) && (pool = event.getTable().getPool("main")) != null) {
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(FISH, 85, -1));
            AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(JUNK, 10, -2));
            if (((Boolean)AquaConfig.NEPTUNIUM_OPTIONS.addNeptunesBountyToLoot.get()).booleanValue()) {
                AquaLootTables.addEntry(pool, AquaLootTables.getInjectEntry(NEPTUNIUM, 1, 2));
            }
        }
    }

    private static LootEntry getInjectEntry(ResourceLocation location, int weight, int quality) {
        return TableLootEntry.func_216171_a((ResourceLocation)location).func_216086_a(weight).func_216085_b(quality).func_216081_b();
    }

    private static void addEntry(LootPool pool, LootEntry entry) {
        try {
            List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(pool);
            if (lootEntries.stream().anyMatch(e -> e == entry)) {
                throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
            }
            lootEntries.add(entry);
        }
        catch (IllegalAccessException e2) {
            Aquaculture.LOG.error("Error occurred when attempting to add a new entry, to the fishing loot table");
            e2.printStackTrace();
        }
    }
}

