/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.client.renderer.AquatemRenderer;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaFoods;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.item.AquaFishBucket;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.DyeableItem;
import com.teammetallurgy.aquaculture.item.FishItem;
import com.teammetallurgy.aquaculture.item.ItemFilletKnife;
import com.teammetallurgy.aquaculture.item.ItemMessageInABottle;
import com.teammetallurgy.aquaculture.item.LootBoxItem;
import com.teammetallurgy.aquaculture.item.SimpleItem;
import com.teammetallurgy.aquaculture.item.neptunium.NeptuniumArmor;
import com.teammetallurgy.aquaculture.item.neptunium.NeptuniumBow;
import com.teammetallurgy.aquaculture.item.neptunium.NeptuniumHoe;
import com.teammetallurgy.aquaculture.item.neptunium.NeptuniumPickaxe;
import com.teammetallurgy.aquaculture.item.neptunium.NeptuniumShovel;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Foods;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SoupItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class AquaItems {
    private static List<Item> ITEMS = Lists.newArrayList();
    public static final Item IRON_FISHING_ROD = AquaItems.register((Item)new AquaFishingRodItem((IItemTier)ItemTier.IRON, new Item.Properties().func_200915_b(125).func_200916_a(Aquaculture.GROUP)), "iron_fishing_rod");
    public static final Item GOLD_FISHING_ROD = AquaItems.register((Item)new AquaFishingRodItem((IItemTier)ItemTier.GOLD, new Item.Properties().func_200915_b(55).func_200916_a(Aquaculture.GROUP)), "gold_fishing_rod");
    public static final Item DIAMOND_FISHING_ROD = AquaItems.register((Item)new AquaFishingRodItem((IItemTier)ItemTier.DIAMOND, new Item.Properties().func_200915_b(450).func_200916_a(Aquaculture.GROUP)), "diamond_fishing_rod");
    public static final Item NEPTUNIUM_FISHING_ROD = AquaItems.register((Item)new AquaFishingRodItem(AquacultureAPI.MATS.NEPTUNIUM, new Item.Properties().func_200915_b(1000).func_200916_a(Aquaculture.GROUP)), "neptunium_fishing_rod");
    public static final Item WORM = AquaItems.register((Item)AquacultureAPI.createBait(20, 1, Aquaculture.GROUP), "worm");
    public static final Item FISHING_LINE = AquaItems.register((Item)new DyeableItem(0), "fishing_line");
    public static final Item BOBBER = AquaItems.register((Item)new DyeableItem(13838890), "bobber");
    public static final Item NEPTUNIUM_NUGGET = AquaItems.register((Item)new SimpleItem(), "neptunium_nugget");
    public static final Item NEPTUNIUM_INGOT = AquaItems.register((Item)new SimpleItem(), "neptunium_ingot");
    public static final Item NEPTUNIUM_PICKAXE = AquaItems.register((Item)new NeptuniumPickaxe(AquacultureAPI.MATS.NEPTUNIUM, 1, -2.8f), "neptunium_pickaxe");
    public static final Item NEPTUNIUM_SHOVEL = AquaItems.register((Item)new NeptuniumShovel(AquacultureAPI.MATS.NEPTUNIUM, 1.5f, -3.0f), "neptunium_shovel");
    public static final Item NEPTUNIUM_AXE = AquaItems.register((Item)new AxeItem(AquacultureAPI.MATS.NEPTUNIUM, 8.0f, -3.0f, new Item.Properties().func_200916_a(Aquaculture.GROUP)), "neptunium_axe");
    public static final Item NEPTUNIUM_HOE = AquaItems.register((Item)new NeptuniumHoe(AquacultureAPI.MATS.NEPTUNIUM, 0.4f), "neptunium_hoe");
    public static final Item NEPTUNIUM_SWORD = AquaItems.register((Item)new SwordItem(AquacultureAPI.MATS.NEPTUNIUM, 3, -2.4f, new Item.Properties().func_200916_a(Aquaculture.GROUP)), "neptunium_sword");
    public static final Item NEPTUNIUM_BOW = AquaItems.register((Item)new NeptuniumBow(), "neptunium_bow");
    public static final Item NEPTUNIUM_HELMET = AquaItems.register(new NeptuniumArmor(AquacultureAPI.MATS.NEPTINIUM_ARMOR, EquipmentSlotType.HEAD).setArmorTexture("neptunium_layer_1"), "neptunium_helmet");
    public static final Item NEPTUNIUM_PLATE = AquaItems.register(new NeptuniumArmor(AquacultureAPI.MATS.NEPTINIUM_ARMOR, EquipmentSlotType.CHEST).setArmorTexture("neptunium_layer_1"), "neptunium_chestplate");
    public static final Item NEPTUNIUM_LEGS = AquaItems.register(new NeptuniumArmor(AquacultureAPI.MATS.NEPTINIUM_ARMOR, EquipmentSlotType.LEGS).setArmorTexture("neptunium_layer_2"), "neptunium_leggings");
    public static final Item NEPTUNIUM_BOOTS = AquaItems.register(new NeptuniumArmor(AquacultureAPI.MATS.NEPTINIUM_ARMOR, EquipmentSlotType.FEET).setArmorTexture("neptunium_layer_1"), "neptunium_boots");
    public static final Item WOODEN_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife((IItemTier)ItemTier.WOOD), "wooden_fillet_knife");
    public static final Item STONE_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife((IItemTier)ItemTier.STONE), "stone_fillet_knife");
    public static final Item IRON_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife((IItemTier)ItemTier.IRON), "iron_fillet_knife");
    public static final Item GOLD_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife((IItemTier)ItemTier.GOLD), "gold_fillet_knife");
    public static final Item DIAMOND_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife((IItemTier)ItemTier.DIAMOND), "diamond_fillet_knife");
    public static final Item NEPTINIUM_FILLET_KNIFE = AquaItems.register((Item)new ItemFilletKnife(AquacultureAPI.MATS.NEPTUNIUM), "neptunium_fillet_knife");
    public static final Item DRIFTWOOD = AquaItems.register((Item)new SimpleItem(), "driftwood");
    public static final Item TIN_CAN = AquaItems.register((Item)new SimpleItem(), "tin_can");
    public static final Item NESSAGE_IN_A_BOTTLE = AquaItems.register((Item)new ItemMessageInABottle(), "message_in_a_bottle");
    public static final Item BOX = AquaItems.register((Item)new LootBoxItem(AquaLootTables.BOX), "box");
    public static final Item LOCKBOX = AquaItems.register((Item)new LootBoxItem(AquaLootTables.LOCKBOX), "lockbox");
    public static final Item TREASURE_CHEST = AquaItems.register((Item)new LootBoxItem(AquaLootTables.TREASURE_CHEST), "treasure_chest");
    public static final Item ALGAE = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.ALGAE)), "algae");
    public static final Item FISH_BONES = AquaItems.register((Item)new SimpleItem(), "fish_bones");
    public static final Item FISH_FILLET = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.FISH_RAW)), "fish_fillet_raw");
    public static final Item COOKED_FILLET = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.FISH_FILLET)), "fish_fillet_cooked");
    public static final Item FROG_LEGS = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.FISH_RAW)), "frog_legs_raw");
    public static final Item COOKED_FROG_LEGS = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.FROG_LEGS)), "frog_legs_cooked");
    public static final Item TURTLE_SOUP = AquaItems.register((Item)new SoupItem(new Item.Properties().func_200917_a(1).func_200916_a(Aquaculture.GROUP).func_221540_a(Foods.field_221448_x)), "turtle_soup");
    public static final Item SUSHI = AquaItems.register(new Item(new Item.Properties().func_200916_a(Aquaculture.GROUP).func_221540_a(AquaFoods.SUSHI)), "sushi");
    public static final Item ATLANTIC_COD = FishRegistry.register(new FishItem(), "atlantic_cod");
    public static final Item BLACKFISH = FishRegistry.register(new FishItem(), "blackfish");
    public static final Item PACIFIC_HALIBUT = FishRegistry.register(new FishItem(), "pacific_halibut", FishType.HALIBUT);
    public static final Item ATLANTIC_HALIBUT = FishRegistry.register(new FishItem(), "atlantic_halibut", FishType.HALIBUT);
    public static final Item ATLANTIC_HERRING = FishRegistry.register(new FishItem(), "atlantic_herring", FishType.SMALL);
    public static final Item PINK_SALMON = FishRegistry.register(new FishItem(), "pink_salmon");
    public static final Item POLLOCK = FishRegistry.register(new FishItem(), "pollock");
    public static final Item RAINBOW_TROUT = FishRegistry.register(new FishItem(), "rainbow_trout");
    public static final Item BAYAD = FishRegistry.register(new FishItem(), "bayad", FishType.CATFISH);
    public static final Item BOULTI = FishRegistry.register(new FishItem(), "boulti", FishType.SMALL);
    public static final Item CAPITAINE = FishRegistry.register(new FishItem(), "capitaine");
    public static final Item SYNODONTIS = FishRegistry.register(new FishItem(), "synodontis", FishType.SMALL);
    public static final Item SMALLMOUTH_BASS = FishRegistry.register(new FishItem(), "smallmouth_bass");
    public static final Item BLUEGILL = FishRegistry.register(new FishItem(), "bluegill", FishType.SMALL);
    public static final Item BROWN_TROUT = FishRegistry.register(new FishItem(), "brown_trout");
    public static final Item CARP = FishRegistry.register(new FishItem(), "carp", FishType.LARGE);
    public static final Item CATFISH = FishRegistry.register(new FishItem(), "catfish", FishType.CATFISH);
    public static final Item GAR = FishRegistry.register(new FishItem(), "gar", FishType.LONGNOSE);
    public static final Item MINNOW = FishRegistry.register(AquacultureAPI.createBait(50, 1, Aquaculture.GROUP), "minnow", FishType.SMALL);
    public static final Item MUSKELLUNGE = FishRegistry.register(new FishItem(), "muskellunge", FishType.LONGNOSE);
    public static final Item PERCH = FishRegistry.register(new FishItem(), "perch", FishType.SMALL);
    public static final Item ARAPAIMA = FishRegistry.register(new FishItem(), "arapaima", FishType.LONGNOSE);
    public static final Item PIRANHA = FishRegistry.register(new FishItem(), "piranha", FishType.SMALL);
    public static final Item TAMBAQUI = FishRegistry.register(new FishItem(), "tambaqui", FishType.LARGE);
    public static final Item BROWN_SHROOMA = FishRegistry.register(new FishItem(), "brown_shrooma", FishType.SMALL);
    public static final Item RED_SHROOMA = FishRegistry.register(new FishItem(), "red_shrooma", FishType.SMALL);
    public static final Item JELLYFISH = FishRegistry.register(new SimpleItem(), "jellyfish", FishType.JELLYFISH);
    public static final Item RED_GROUPER = FishRegistry.register(new FishItem(), "red_grouper");
    public static final Item TUNA = FishRegistry.register(new FishItem(), "tuna", FishType.LARGE);
    public static final Item FROG = AquaItems.register((Item)new SimpleItem(), "frog");
    public static final Item LEECH = AquaItems.register((Item)AquacultureAPI.createBait(35, 1, Aquaculture.GROUP), "leech");
    public static final Item GOLDFISH = AquaItems.register((Item)new SimpleItem(), "goldfish");
    public static final Item BOX_TURTLE = AquaItems.register((Item)new SimpleItem(), "box_turtle");
    public static final Item ARRAU_TURTLE = AquaItems.register((Item)new SimpleItem(), "arrau_turtle");
    public static final Item STARSHELL_TURTLE = AquaItems.register((Item)new SimpleItem(), "starshell_turtle");
    public static final Item NEPTUNES_BOUNTY = AquaItems.register((Item)new BlockItem(AquaBlocks.NEPTUNES_BOUNTY, new Item.Properties().func_200916_a(Aquaculture.GROUP).setISTER(() -> AquatemRenderer::new)), "neptunes_bounty");
    public static final Item TACKLE_BOX = AquaItems.register((Item)new BlockItem(AquaBlocks.TACKLE_BOX, new Item.Properties().func_200917_a(1).func_200916_a(Aquaculture.GROUP).setISTER(() -> AquatemRenderer::new)), "tackle_box");
    public static final Item OAK_FISH_MOUNT = AquacultureAPI.registerFishMount("oak_fish_mount");
    public static final Item SPRUCE_FISH_MOUNT = AquacultureAPI.registerFishMount("spruce_fish_mount");
    public static final Item BIRCH_FISH_MOUNT = AquacultureAPI.registerFishMount("birch_fish_mount");
    public static final Item JUNGLE_FISH_MOUNT = AquacultureAPI.registerFishMount("jungle_fish_mount");
    public static final Item ACACIA_FISH_MOUNT = AquacultureAPI.registerFishMount("acacia_fish_mount");
    public static final Item DARK_OAK_FISH_MOUNT = AquacultureAPI.registerFishMount("dark_oak_fish_mount");

    public static Item register(@Nonnull Item item, @Nonnull String name) {
        return AquaItems.register(item, new ResourceLocation("aquaculture", name));
    }

    public static Item register(@Nonnull Item item, @Nonnull ResourceLocation registryName) {
        item.setRegistryName(registryName);
        ITEMS.add(item);
        return item;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (EntityType entityType : FishRegistry.fishEntities) {
            if (entityType.getRegistryName() == null) continue;
            AquaFishBucket bucket = new AquaFishBucket(entityType, (Fluid)Fluids.field_204546_a, new Item.Properties().func_200917_a(1).func_200916_a(Aquaculture.GROUP));
            bucket.setRegistryName(entityType.getRegistryName().func_110623_a() + "_bucket");
            event.getRegistry().register((IForgeRegistryEntry)bucket);
            AquaFishEntity.BUCKETS.put((EntityType<AquaFishEntity>)entityType, (Item)bucket);
        }
    }
}

