/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture;

import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.loot.BiomeTagCheck;
import com.teammetallurgy.aquaculture.loot.FishReadFromJson;
import com.teammetallurgy.aquaculture.loot.FishWeightHandler;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="aquaculture")
public class Aquaculture {
    public static Aquaculture instance;
    public static final boolean IS_DEV;
    public static final String MOD_ID = "aquaculture";
    public static final Logger LOG;
    public static final ItemGroup GROUP;

    public Aquaculture() {
        instance = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupCommon);
        modBus.addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AquaConfig.spec);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new BiomeTagCheck.Serializer());
            FishWeightHandler.registerFishData();
            AquaEntities.setSpawnPlacement();
            AquaEntities.addEntitySpawns();
            FishReadFromJson.addFishSpawns();
            if (((Boolean)AquaConfig.BASIC_OPTIONS.aqFishToBreedCats.get()).booleanValue()) {
                FishRegistry.addCatBreeding();
            }
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientHandler.setupClient();
    }

    static {
        IS_DEV = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get()).filter(v -> v.equals("MOD_DEV")).isPresent();
        LOG = LogManager.getLogger((String)MOD_ID);
        GROUP = new ItemGroup(MOD_ID){

            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)AquaItems.IRON_FISHING_ROD);
            }
        };
    }
}

