/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core.registry;

import com.markus1002.autumnity.client.renderer.entity.SnailRenderer;
import com.markus1002.autumnity.common.entity.passive.SnailEntity;
import com.markus1002.autumnity.core.Autumnity;
import com.markus1002.autumnity.core.Config;
import com.markus1002.autumnity.core.registry.ModBiomes;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final RegistryHelper HELPER = Autumnity.REGISTRY_HELPER;
    public static final RegistryObject<EntityType<SnailEntity>> SNAIL = HELPER.createLivingEntity("snail", SnailEntity::new, EntityClassification.CREATURE, 0.8f, 0.9f);

    public static void setupEntitySpawns(Biome biome) {
        if (biome == ModBiomes.MAPLE_FOREST.get() || biome == ModBiomes.MAPLE_FOREST_HILLS.get() || biome == ModBiomes.PUMPKIN_FIELDS.get()) {
            ModEntities.addEntitySpawn(biome, EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)SNAIL.get(), 12, 2, 2));
        }
        if (((List)Config.COMMON.snailSpawnBiomes.get()).contains(biome.getRegistryName().toString())) {
            ModEntities.addEntitySpawn(biome, EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)SNAIL.get(), 10, 2, 2));
        }
    }

    private static void addEntitySpawn(Biome biome, EntityClassification entityclassification, Biome.SpawnListEntry spawnlistentry) {
        biome.func_76747_a(entityclassification).add(spawnlistentry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupEntitiesClient() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SNAIL.get()), SnailRenderer::new);
    }
}

