/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.compat;

import de.melanx.morevanillalib.LibConfigHandler;
import de.melanx.morevanillalib.api.BigBreakMaterials;
import de.melanx.morevanillalib.data.ModTags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("morevanillalib", "plugin/main");

    private static void addInfoPage(IRecipeRegistration reg, Collection<Item> items, String name) {
        String key = JeiCompat.getDescKey(new ResourceLocation("morevanillalib", name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new String[]{key});
    }

    public static void addValueInfoPage(IRecipeRegistration reg, Item item, String name, Object ... values) {
        List<Item> items = Collections.singletonList(item);
        JeiCompat.addValueInfoPage(reg, items, name, values);
    }

    private static void addValueInfoPage(IRecipeRegistration reg, Collection<Item> items, String name, Object ... values) {
        String key = JeiCompat.getDescKey(new ResourceLocation("morevanillalib", name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)key, (Object[])values)});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }

    private static Item getItemFromIngredient(Ingredient ingredient) {
        return ingredient.func_193365_a()[0].func_77973_b();
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JeiCompat.addValueInfoPage(registration, ModTags.Items.BONE_TOOLS.func_199885_a(), "bone_tools", LibConfigHandler.boneDurability.get(), (Integer)LibConfigHandler.boneDurability.get() * 5, LibConfigHandler.boneHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.BONE.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.COAL_TOOLS.func_199885_a(), "coal_tools", LibConfigHandler.coalDurability.get(), (Integer)LibConfigHandler.coalDurability.get() * 5, LibConfigHandler.coalHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.COAL.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.EMERALD_TOOLS.func_199885_a(), "emerald_tools", LibConfigHandler.emeraldDurability.get(), (Integer)LibConfigHandler.emeraldDurability.get() * 5, LibConfigHandler.emeraldHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.EMERALD.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.ENDER_TOOLS.func_199885_a(), "ender_tools", LibConfigHandler.enderDurability.get(), (Integer)LibConfigHandler.enderDurability.get() * 5, LibConfigHandler.enderHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.ENDER.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.FIERY_TOOLS.func_199885_a(), "fiery_tools", LibConfigHandler.fieryDurability.get(), (Integer)LibConfigHandler.fieryDurability.get() * 5, LibConfigHandler.fieryHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.FIERY.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.GLOWSTONE_TOOLS.func_199885_a(), "glowstone_tools", LibConfigHandler.glowstoneDurability.get(), (Integer)LibConfigHandler.glowstoneDurability.get() * 5, LibConfigHandler.glowstoneHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.GLOWSTONE.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.LAPIS_TOOLS.func_199885_a(), "lapis_tools", LibConfigHandler.lapisDurability.get(), (Integer)LibConfigHandler.lapisDurability.get() * 5, LibConfigHandler.lapisHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.LAPIS.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.NETHER_TOOLS.func_199885_a(), "nether_tools", LibConfigHandler.netherDurability.get(), (Integer)LibConfigHandler.netherDurability.get() * 5, LibConfigHandler.netherHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.NETHER.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.OBSIDIAN_TOOLS.func_199885_a(), "obsidian_tools", LibConfigHandler.obsidianDurability.get(), (Integer)LibConfigHandler.obsidianDurability.get() * 5, LibConfigHandler.obsidianHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.OBSIDIAN.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.PAPER_TOOLS.func_199885_a(), "paper_tools", LibConfigHandler.paperDurability.get(), (Integer)LibConfigHandler.paperDurability.get() * 5, LibConfigHandler.paperHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.PAPER.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.PRISMARINE_TOOLS.func_199885_a(), "prismarine_tools", LibConfigHandler.prismarineDurability.get(), (Integer)LibConfigHandler.prismarineDurability.get() * 5, LibConfigHandler.prismarineHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.PRISMARINE.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.QUARTZ_TOOLS.func_199885_a(), "quartz_tools", LibConfigHandler.quartzDurability.get(), (Integer)LibConfigHandler.quartzDurability.get() * 5, LibConfigHandler.quartzHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.QUARTZ.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.REDSTONE_TOOLS.func_199885_a(), "redstone_tools", LibConfigHandler.redstoneDurability.get(), (Integer)LibConfigHandler.redstoneDurability.get() * 5, LibConfigHandler.redstoneHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.REDSTONE.func_200924_f()).func_200296_o().func_150254_d());
        JeiCompat.addValueInfoPage(registration, ModTags.Items.SLIME_TOOLS.func_199885_a(), "slime_tools", LibConfigHandler.slimeDurability.get(), (Integer)LibConfigHandler.slimeDurability.get() * 5, LibConfigHandler.slimeHarvestlevel.get(), JeiCompat.getItemFromIngredient(BigBreakMaterials.SLIME.func_200924_f()).func_200296_o().func_150254_d());
        if (((Boolean)LibConfigHandler.extraDrop.get()).booleanValue()) {
            JeiCompat.addValueInfoPage(registration, ModTags.Items.ALL_TOOLS.func_199885_a(), "extra_drop", (double)((Integer)LibConfigHandler.extraDropChance.get()).intValue() / 10.0);
        }
        if (((Boolean)LibConfigHandler.extraDamage.get()).booleanValue()) {
            double extraDamageChance = (double)((Integer)LibConfigHandler.extraDamageChance.get()).intValue() / 10.0;
            JeiCompat.addValueInfoPage(registration, ModTags.Items.BONE_TOOLS.func_199885_a(), "bone_damage", extraDamageChance);
            JeiCompat.addValueInfoPage(registration, ModTags.Items.ENDER_TOOLS.func_199885_a(), "ender_damage", extraDamageChance);
            JeiCompat.addValueInfoPage(registration, ModTags.Items.FIERY_TOOLS.func_199885_a(), "fiery_damage", extraDamageChance);
            JeiCompat.addValueInfoPage(registration, ModTags.Items.PRISMARINE_TOOLS.func_199885_a(), "prismarine_damage", extraDamageChance);
            JeiCompat.addValueInfoPage(registration, ModTags.Items.SLIME_TOOLS.func_199885_a(), "slime_damage", extraDamageChance);
        }
        if (((Boolean)LibConfigHandler.headDrop.get()).booleanValue()) {
            JeiCompat.addValueInfoPage(registration, ModTags.Items.BONE_TOOLS.func_199885_a(), "bone_heads", (double)((Integer)LibConfigHandler.headDropChance.get()).intValue() / 10.0);
        }
        if (((Boolean)LibConfigHandler.damageByPaperTools.get()).booleanValue()) {
            JeiCompat.addValueInfoPage(registration, ModTags.Items.PAPER_TOOLS.func_199885_a(), "paper_damage", (double)((Integer)LibConfigHandler.damageByPaperToolsChance.get()).intValue() / 10.0, (double)((Integer)LibConfigHandler.minPaperDamage.get()).intValue() / 2.0, (double)((Integer)LibConfigHandler.maxPaperDamage.get()).intValue() / 2.0);
        }
        if (((Boolean)LibConfigHandler.autoSmelt.get()).booleanValue()) {
            JeiCompat.addInfoPage(registration, ModTags.Items.FIERY_TOOLS.func_199885_a(), "fiery_smelt");
        }
        if (((Boolean)LibConfigHandler.glowstoneDrops.get()).booleanValue()) {
            JeiCompat.addInfoPage(registration, ModTags.Items.GLOWSTONE_TOOLS.func_199885_a(), "glowstone_drops");
        }
    }
}

