/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api;

import de.melanx.morevanillalib.LibConfigHandler;
import de.melanx.morevanillalib.api.BigBreakItem;
import de.melanx.morevanillalib.api.BigBreakMaterials;
import de.melanx.morevanillalib.api.IBreakValidator;
import de.melanx.morevanillalib.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockBreaker {
    private BlockBreaker() {
    }

    public static void breakInRadius(World world, PlayerEntity playerEntity, int radius, IBreakValidator breakValidator, boolean damageTool) {
        if (!world.field_72995_K) {
            List<BlockPos> brokenBlocks = BlockBreaker.getBreakBlocks(world, playerEntity, radius);
            ItemStack heldItem = playerEntity.func_184614_ca();
            IItemTier toolMaterial = ((BigBreakItem)heldItem.func_77973_b()).getToolMaterial();
            int silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem);
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
            for (BlockPos pos : brokenBlocks) {
                BlockState state = world.func_180495_p(pos);
                if (!breakValidator.canBreak(state)) continue;
                world.func_217377_a(pos, false);
                if (playerEntity.field_71075_bZ.field_75098_d) {
                    if (state.removedByPlayer(world, pos, playerEntity, true, state.func_204520_s())) {
                        state.func_177230_c().func_176206_d((IWorld)world, pos, state);
                    }
                } else {
                    heldItem.func_77973_b().func_179218_a(heldItem, world, state, pos, (LivingEntity)playerEntity);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    state.func_177230_c().func_176206_d((IWorld)world, pos, state);
                    state.func_177230_c().func_180657_a(world, playerEntity, pos, state, tileEntity, heldItem);
                    state.func_177230_c().func_180637_b(world, pos, state.func_177230_c().getExpDrop(state, (IWorldReader)world, pos, fortune, silktouch));
                    BlockBreaker.spawnExtraDrops(toolMaterial, world, state.func_177230_c(), pos, heldItem);
                }
                if (damageTool) {
                    heldItem.func_222118_a(1, (LivingEntity)playerEntity, player -> {});
                }
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
        }
    }

    private static void spawnExtraDrops(IItemTier toolMaterial, World world, Block block, BlockPos pos, ItemStack heldItem) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem) >= 1) {
            return;
        }
        ToolUtil.extraDrop(world, pos, toolMaterial);
        if (((Boolean)LibConfigHandler.doubleDrop.get()).booleanValue()) {
            switch ((BigBreakMaterials)toolMaterial) {
                case DIAMOND: {
                    int chance;
                    ItemStack drop;
                    if (block == Blocks.field_150482_ag) {
                        drop = new ItemStack((IItemProvider)Items.field_151045_i);
                        chance = (Integer)LibConfigHandler.diamondDoubleDropChance.get();
                        if (world.field_73012_v.nextInt(1000) < chance && ((Boolean)LibConfigHandler.diamondDoubleDrop.get()).booleanValue()) {
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                        }
                    }
                }
                case COAL: {
                    int chance;
                    ItemStack drop;
                    if (block == Blocks.field_150365_q) {
                        drop = new ItemStack((IItemProvider)Items.field_151044_h);
                        chance = (Integer)LibConfigHandler.coalDoubleDropChance.get();
                        if (world.field_73012_v.nextInt(1000) < chance && ((Boolean)LibConfigHandler.coalDoubleDrop.get()).booleanValue()) {
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                        }
                    }
                }
                case EMERALD: {
                    int chance;
                    ItemStack drop;
                    if (block == Blocks.field_150412_bA) {
                        drop = new ItemStack((IItemProvider)Items.field_151166_bC);
                        chance = (Integer)LibConfigHandler.emeraldDoubleDropChance.get();
                        if (world.field_73012_v.nextInt(1000) < chance && ((Boolean)LibConfigHandler.emeraldDoubleDrop.get()).booleanValue()) {
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                        }
                    }
                }
                case LAPIS: {
                    int i;
                    int chance;
                    ItemStack drop;
                    if (block == Blocks.field_150369_x) {
                        drop = new ItemStack((IItemProvider)Items.field_196128_bn);
                        chance = (Integer)LibConfigHandler.lapisDoubleDropChance.get();
                        if (world.field_73012_v.nextInt(1000) < chance && ((Boolean)LibConfigHandler.lapisDoubleDrop.get()).booleanValue()) {
                            i = world.field_73012_v.nextInt(3);
                            drop.func_190920_e(i + 1);
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                        }
                    }
                }
                case QUARTZ: {
                    int chance;
                    ItemStack drop;
                    if (block == Blocks.field_196766_fg) {
                        drop = new ItemStack((IItemProvider)Items.field_151128_bU);
                        chance = (Integer)LibConfigHandler.quartzDoubleDropChance.get();
                        if (world.field_73012_v.nextInt(1000) < chance && ((Boolean)LibConfigHandler.quartzDoubleDrop.get()).booleanValue()) {
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                        }
                    }
                }
                case REDSTONE: {
                    if (block != Blocks.field_150450_ax) break;
                    ItemStack drop = new ItemStack((IItemProvider)Items.field_151137_ax);
                    int chance = (Integer)LibConfigHandler.redstoneDoubleDropChance.get();
                    if (world.field_73012_v.nextInt(1000) >= chance || !((Boolean)LibConfigHandler.redstoneDoubleDrop.get()).booleanValue()) break;
                    int i = world.field_73012_v.nextInt(3);
                    drop.func_190920_e(i + 1);
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
                }
            }
        }
    }

    private static void dropItems(World world, List<ItemStack> stacks, BlockPos pos) {
        for (ItemStack stack : stacks) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_217376_c((Entity)itemEntity);
        }
    }

    public static List<BlockPos> getBreakBlocks(World world, PlayerEntity player, int radius) {
        ArrayList<BlockPos> potentialBrokenBlocks = new ArrayList<BlockPos>();
        Vec3d eyePosition = player.func_174824_e(1.0f);
        Vec3d rotation = player.func_70676_i(1.0f);
        Vec3d combined = eyePosition.func_72441_c(rotation.field_72450_a * 5.0, rotation.field_72448_b * 5.0, rotation.field_72449_c * 5.0);
        BlockRayTraceResult rayTraceResult = world.func_217299_a(new RayTraceContext(eyePosition, combined, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction.Axis axis = rayTraceResult.func_216354_b().func_176740_k();
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        positions.add(new BlockPos(x, y, z));
                    }
                }
            }
            BlockPos origin = rayTraceResult.func_216350_a();
            for (BlockPos pos : positions) {
                if (axis == Direction.Axis.Y) {
                    if (pos.func_177956_o() != 0) continue;
                    potentialBrokenBlocks.add(origin.func_177971_a((Vec3i)pos));
                    continue;
                }
                if (axis == Direction.Axis.X) {
                    if (pos.func_177958_n() != 0) continue;
                    potentialBrokenBlocks.add(origin.func_177971_a((Vec3i)pos));
                    continue;
                }
                if (axis != Direction.Axis.Z || pos.func_177952_p() != 0) continue;
                potentialBrokenBlocks.add(origin.func_177971_a((Vec3i)pos));
            }
        }
        return potentialBrokenBlocks;
    }
}

