/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.morevanillalib.api;

import de.melanx.morevanillalib.LibConfigHandler;
import de.melanx.morevanillalib.api.BigBreakMaterials;
import de.melanx.morevanillalib.api.BlockBreaker;
import de.melanx.morevanillalib.core.LibDamageSource;
import de.melanx.morevanillalib.util.ToolUtil;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BigBreakItem
extends PickaxeItem {
    private final IItemTier toolMaterial;

    public BigBreakItem(IItemTier toolMaterial, float attackSpeed) {
        super(toolMaterial, 0, attackSpeed, new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
        this.toolMaterial = toolMaterial;
    }

    public boolean func_195938_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        int radius = 1;
        if (player.func_213453_ef()) {
            radius = 0;
        }
        float originHardness = world.func_180495_p(pos).func_185887_b(null, null);
        if (player.func_184614_ca().func_150998_b(world.func_180495_p(pos))) {
            BlockBreaker.breakInRadius(world, player, radius, breakState -> {
                double hardness = breakState.func_185887_b(null, null);
                boolean isEffective = player.func_184614_ca().func_150998_b(breakState);
                boolean verifyHardness = hardness < (double)(originHardness * 5.0f) && hardness > 0.0;
                return isEffective && verifyHardness;
            }, true);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ToolUtil.extraDrop(attacker.func_130014_f_(), target.func_180425_c(), this.getToolMaterial());
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!world.field_72995_K && state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            int chance = (Integer)LibConfigHandler.damageByPaperToolsChance.get();
            if (this.getToolMaterial() == BigBreakMaterials.PAPER && ((Boolean)LibConfigHandler.damageByPaperTools.get()).booleanValue() && new Random().nextInt(1000) < chance) {
                entityLiving.func_70097_a(LibDamageSource.PAPER_CUT, (float)(new Random().nextInt((Integer)LibConfigHandler.maxPaperDamage.get()) + (Integer)LibConfigHandler.minPaperDamage.get()));
            }
        }
        if (!this.func_150897_b(state)) {
            ToolUtil.extraDrop(world, pos, this.getToolMaterial());
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (this.getToolMaterial() == BigBreakMaterials.SLIME) {
            stack.func_77966_a(Enchantments.field_180313_o, 3);
        }
    }

    public int getBurnTime(ItemStack stack) {
        if (this.getToolMaterial() == BigBreakMaterials.WOOD) {
            return 400;
        }
        return 0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78040_i || group == ItemGroup.field_78027_g) {
            ItemStack item = new ItemStack((IItemProvider)this);
            if (this.getToolMaterial() == BigBreakMaterials.SLIME) {
                item.func_77966_a(Enchantments.field_180313_o, 3);
            }
            items.add((Object)item);
        }
    }

    public IItemTier getToolMaterial() {
        return this.toolMaterial;
    }
}

