/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.container;

import com.tfar.metalbarrels.MetalBarrels;
import com.tfar.metalbarrels.tile.AbstractBarrelTile;
import javax.annotation.Nonnull;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class MetalBarrelContainer
extends Container {
    public AbstractBarrelTile tileEntity;
    protected PlayerEntity playerEntity;
    protected IItemHandler playerInventory;
    private int width;
    private int height;

    public MetalBarrelContainer(ContainerType<?> containerType, int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, int width, int height, int containerX, int containerY, int playerY) {
        this(containerType, id, world, pos, playerInventory, player, width, height, containerX, containerY, playerY, 8);
    }

    public MetalBarrelContainer(ContainerType<?> containerType, int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, int width, int height, int containerX, int containerY, int playerY, int playerX) {
        super(containerType, id);
        int j;
        int i;
        this.width = width;
        this.height = height;
        this.tileEntity = (AbstractBarrelTile)world.func_175625_s(pos);
        world.func_180501_a(pos, (BlockState)this.tileEntity.func_195044_w().func_206870_a((IProperty)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(true)), 3);
        if (this.tileEntity.players == 0) {
            this.tileEntity.soundStuff(this.tileEntity.func_195044_w(), SoundEvents.field_219602_O);
            this.tileEntity.changeState(this.tileEntity.func_195044_w(), true);
        }
        ++this.tileEntity.players;
        this.playerEntity = player;
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.tileEntity.handler, j + width * i, containerX + j * 18, containerY + i * 18));
            }
        }
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, j * 18 + playerX, i * 18 + playerY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, i * 18 + playerX, playerY + 58));
        }
    }

    public static MetalBarrelContainer copper(int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.COPPER, id, world, pos, playerInventory, player, 9, 5, 8, 18, 122);
    }

    public static MetalBarrelContainer iron(int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.IRON, id, world, pos, playerInventory, player, 9, 6, 8, 18, 140);
    }

    public static MetalBarrelContainer silver(int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.SILVER, id, world, pos, playerInventory, player, 9, 8, 8, 18, 176);
    }

    public static MetalBarrelContainer gold(int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.GOLD, id, world, pos, playerInventory, player, 9, 9, 8, 18, 194);
    }

    public static MetalBarrelContainer diamond(int id, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.DIAMOND, id, world, pos, playerInventory, player, 12, 9, 8, 18, 194, 35);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return MetalBarrelContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)this.tileEntity.func_195044_w().func_177230_c());
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.height * this.width ? !this.func_75135_a(itemstack1, this.height * this.width, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.height * this.width, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        if (this.tileEntity == null) {
            MetalBarrels.logger.warn("unexpected null on container close");
            return;
        }
        if (!playerIn.func_175149_v()) {
            --this.tileEntity.players;
        }
        if (this.tileEntity.players <= 0) {
            this.tileEntity.soundStuff(this.tileEntity.func_195044_w(), SoundEvents.field_219601_N);
            this.tileEntity.changeState(playerIn.field_70170_p.func_180495_p(this.tileEntity.func_174877_v()), false);
        }
    }
}

