/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels;

import com.tfar.metalbarrels.block.CrystalBarrelBlock;
import com.tfar.metalbarrels.block.MetalBarrelBlock;
import com.tfar.metalbarrels.container.MetalBarrelContainer;
import com.tfar.metalbarrels.item.BarrelUpgradeItem;
import com.tfar.metalbarrels.item.UpgradeInfo;
import com.tfar.metalbarrels.network.PacketHandler;
import com.tfar.metalbarrels.screens.CopperBarrelScreen;
import com.tfar.metalbarrels.screens.DiamondBarrelScreen;
import com.tfar.metalbarrels.screens.GoldBarrelScreen;
import com.tfar.metalbarrels.screens.IronBarrelScreen;
import com.tfar.metalbarrels.screens.SilverBarrelScreen;
import com.tfar.metalbarrels.tile.CopperBarrelTile;
import com.tfar.metalbarrels.tile.CrystalBarrelTile;
import com.tfar.metalbarrels.tile.DiamondBarrelTile;
import com.tfar.metalbarrels.tile.GoldBarrelTile;
import com.tfar.metalbarrels.tile.IronBarrelTile;
import com.tfar.metalbarrels.tile.SilverBarrelTile;
import com.tfar.metalbarrels.util.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="metalbarrels")
public class MetalBarrels {
    public static final String MODID = "metalbarrels";
    public static final Logger logger = LogManager.getLogger();
    public static final ItemGroup tab = new ItemGroup("metalbarrels"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ObjectHolders.DIAMOND_BARREL);
        }
    };

    public MetalBarrels() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BarrelUpgradeItem.IRON_CHESTS_LOADED = ModList.get().isLoaded("ironchest");
        PacketHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ObjectHolders.COPPER, CopperBarrelScreen::new);
        ScreenManager.func_216911_a(ObjectHolders.IRON, IronBarrelScreen::new);
        ScreenManager.func_216911_a(ObjectHolders.SILVER, SilverBarrelScreen::new);
        ScreenManager.func_216911_a(ObjectHolders.GOLD, GoldBarrelScreen::new);
        ScreenManager.func_216911_a(ObjectHolders.DIAMOND, DiamondBarrelScreen::new);
    }

    @ObjectHolder(value="metalbarrels")
    public static class ObjectHolders {
        public static final Block COPPER_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> COPPER = null;
        public static final TileEntityType<CopperBarrelTile> COPPER_TILE = null;
        public static final Block IRON_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> IRON = null;
        public static final TileEntityType<IronBarrelTile> IRON_TILE = null;
        public static final Block GOLD_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> GOLD = null;
        public static final TileEntityType<GoldBarrelTile> GOLD_TILE = null;
        public static final Block DIAMOND_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> DIAMOND = null;
        public static final TileEntityType<DiamondBarrelTile> DIAMOND_TILE = null;
        public static final Block OBSIDIAN_BARREL = null;
        public static final Block SILVER_BARREL = null;
        public static final ContainerType<MetalBarrelContainer> SILVER = null;
        public static final TileEntityType<SilverBarrelTile> SILVER_TILE = null;
        public static final Block CRYSTAL_BARREL = null;
        public static final TileEntityType<CrystalBarrelTile> CRYSTAL_TILE = null;
    }

    @ObjectHolder(value="ironchest")
    public static class IronChestObjectHolders {
        public static final Block COPPER_CHEST = null;
        public static final Block IRON_CHEST = null;
        public static final Block SILVER_CHEST = null;
        public static final Block GOLD_CHEST = null;
        public static final Block DIAMOND_CHEST = null;
        public static final Block CRYSTAL_CHEST = null;
        public static final Block OBSIDIAN_CHEST = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        private static final Set<Block> MOD_BLOCKS = new HashSet<Block>();

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            Block.Properties metal = Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.5f, 6.0f).func_200947_a(SoundType.field_185852_e);
            Block.Properties softmetal = metal.harvestLevel(1);
            Block.Properties hardmetal = metal.harvestLevel(2);
            Block.Properties obsidian = Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(15.0f, 6000.0f).harvestLevel(3);
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(softmetal, CopperBarrelTile::new), "copper_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(softmetal, IronBarrelTile::new), "iron_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, SilverBarrelTile::new), "silver_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, GoldBarrelTile::new), "gold_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(hardmetal, DiamondBarrelTile::new), "diamond_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new MetalBarrelBlock(obsidian, DiamondBarrelTile::new), "obsidian_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
            RegistryEvents.registerBlock((Block)new CrystalBarrelBlock(hardmetal.func_226896_b_(), CrystalBarrelTile::new), "crystal_barrel", (IForgeRegistry<Block>)blockRegistryEvent.getRegistry());
        }

        private static void registerBlock(Block block, String name, IForgeRegistry<Block> registry) {
            registry.register(block.setRegistryName(name));
            MOD_BLOCKS.add(block);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            IForgeRegistry registry = itemRegistryEvent.getRegistry();
            Item.Properties properties = new Item.Properties().func_200916_a(tab);
            for (Block block : MOD_BLOCKS) {
                RegistryEvents.registerItem((Item)new BlockItem(block, properties), block.getRegistryName().toString(), (IForgeRegistry<Item>)registry);
            }
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.COPPER_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.COPPER_CHEST, "ironchest")), "wood_to_copper", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.IRON_CHEST, "ironchest")), "wood_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "wood_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "wood_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "wood_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "wood_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.IRON_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.IRON_CHEST, "ironchest")), "copper_to_iron", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "copper_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "copper_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "copper_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "copper_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.SILVER_BARREL))).add(Tags.Blocks.IRON_CHESTS, IronChestObjectHolders.SILVER_CHEST, "ironchest")), "iron_to_silver", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(Tags.Blocks.IRON_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "iron_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(Tags.Blocks.IRON_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "iron_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.IRON_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "iron_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.GOLD_BARREL))).add(Tags.Blocks.SILVER_CHESTS, IronChestObjectHolders.GOLD_CHEST, "ironchest")), "silver_to_gold", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(Tags.Blocks.SILVER_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "silver_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.SILVER_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "silver_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.DIAMOND_BARREL))).add(Tags.Blocks.GOLD_CHESTS, IronChestObjectHolders.DIAMOND_CHEST, "ironchest")), "gold_to_diamond", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.GOLD_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "gold_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.OBSIDIAN_BARREL))).add(Tags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.OBSIDIAN_CHEST, "ironchest")), "diamond_to_obsidian", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.WOODEN_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.WOODEN_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "wood_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.COPPER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.COPPER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "copper_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.IRON_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.IRON_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "iron_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.SILVER_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.SILVER_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "silver_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.GOLD_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.GOLD_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "gold_to_crystal", (IForgeRegistry<Item>)registry);
            RegistryEvents.registerItem(new BarrelUpgradeItem(properties, new UpgradeInfo(new ArrayList<Tag<Block>>(Collections.singleton(Tags.Blocks.DIAMOND_BARRELS)), new ArrayList<Block>(Collections.singleton(ObjectHolders.CRYSTAL_BARREL))).add(Tags.Blocks.DIAMOND_CHESTS, IronChestObjectHolders.CRYSTAL_CHEST, "ironchest")), "diamond_to_crystal", (IForgeRegistry<Item>)registry);
        }

        private static void registerItem(Item item, String name, IForgeRegistry<Item> registry) {
            registry.register(item.setRegistryName(name));
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> MetalBarrelContainer.copper(windowId, inv.field_70458_d.field_70170_p, data.func_179259_c(), inv, inv.field_70458_d)).setRegistryName("copper"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> MetalBarrelContainer.iron(windowId, inv.field_70458_d.field_70170_p, data.func_179259_c(), inv, inv.field_70458_d)).setRegistryName("iron"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> MetalBarrelContainer.silver(windowId, inv.field_70458_d.field_70170_p, data.func_179259_c(), inv, inv.field_70458_d)).setRegistryName("silver"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> MetalBarrelContainer.gold(windowId, inv.field_70458_d.field_70170_p, data.func_179259_c(), inv, inv.field_70458_d)).setRegistryName("gold"));
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> MetalBarrelContainer.diamond(windowId, inv.field_70458_d.field_70170_p, data.func_179259_c(), inv, inv.field_70458_d)).setRegistryName("diamond"));
        }

        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CopperBarrelTile::new, (Block[])new Block[]{ObjectHolders.COPPER_BARREL}).func_206865_a(null).setRegistryName("copper_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(IronBarrelTile::new, (Block[])new Block[]{ObjectHolders.IRON_BARREL}).func_206865_a(null).setRegistryName("iron_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(SilverBarrelTile::new, (Block[])new Block[]{ObjectHolders.SILVER_BARREL}).func_206865_a(null).setRegistryName("silver_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(GoldBarrelTile::new, (Block[])new Block[]{ObjectHolders.GOLD_BARREL}).func_206865_a(null).setRegistryName("gold_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(DiamondBarrelTile::new, (Block[])new Block[]{ObjectHolders.DIAMOND_BARREL, ObjectHolders.OBSIDIAN_BARREL}).func_206865_a(null).setRegistryName("diamond_tile"));
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(CrystalBarrelTile::new, (Block[])new Block[]{ObjectHolders.CRYSTAL_BARREL}).func_206865_a(null).setRegistryName("crystal_tile"));
        }
    }
}

