/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.storage;

import com.commodorethrawn.strawgolem.events.CropGrowthHandler;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class StrawgolemSaveData
extends WorldSavedData {
    private static final String WORLD = "world";
    private static final String POS = "pos";

    public StrawgolemSaveData() {
        super("strawgolem");
    }

    public StrawgolemSaveData(String name) {
        super(name);
        this.func_76185_a();
    }

    public static StrawgolemSaveData get(ServerWorld world) {
        DimensionSavedDataManager storage = world.func_217481_x();
        return (StrawgolemSaveData)storage.func_215752_a(StrawgolemSaveData::new, "strawgolem");
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT listTag = nbt.func_150295_c("listTag", 10);
        for (INBT tag : listTag) {
            DimensionType dimension;
            CompoundNBT entryTag = (CompoundNBT)tag;
            BlockPos pos = null;
            ServerWorld world = null;
            if (entryTag.func_74781_a(POS) != null) {
                pos = NBTUtil.func_186861_c((CompoundNBT)entryTag.func_74775_l(POS));
            }
            if (entryTag.func_74781_a(WORLD) != null && (dimension = DimensionType.func_186069_a((int)entryTag.func_74762_e(WORLD))) != null) {
                world = ServerLifecycleHooks.getCurrentServer().func_71218_a(dimension);
            }
            if (world == null || pos == null) continue;
            CropGrowthHandler.scheduleCrop(world, pos, 3);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        Iterator<CropGrowthHandler.CropQueueEntry> cropIterator = CropGrowthHandler.getCrops();
        ListNBT listTag = new ListNBT();
        while (cropIterator.hasNext()) {
            CompoundNBT entryTag = new CompoundNBT();
            CropGrowthHandler.CropQueueEntry entry = cropIterator.next();
            entryTag.func_218657_a(POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry.getPos()));
            entryTag.func_74768_a(WORLD, entry.getWorld().func_201675_m().func_186058_p().func_186068_a());
            listTag.add((Object)entryTag);
        }
        compound.func_218657_a("listTag", (INBT)listTag);
        return compound;
    }
}

