/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.client.renderer.entity;

import com.commodorethrawn.strawgolem.Strawgolem;
import com.commodorethrawn.strawgolem.client.renderer.entity.model.ModelStrawGolem;
import com.commodorethrawn.strawgolem.config.ConfigHelper;
import com.commodorethrawn.strawgolem.entity.EntityStrawGolem;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class RenderStrawGolem
extends MobRenderer<EntityStrawGolem, ModelStrawGolem> {
    private static final Map<String, ResourceLocation> TEXTURE_MAP;
    private static final ResourceLocation TEXTURE_DEFAULT;
    private static final ResourceLocation TEXTURE_OLD;
    private static final ResourceLocation TEXTURE_DYING;
    private static final ResourceLocation TEXTURE_WINTER;
    private static final boolean IS_DECEMBER;

    public RenderStrawGolem(EntityRendererManager rendermanagerIn) {
        super(rendermanagerIn, (EntityModel)new ModelStrawGolem(), 0.5f);
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
    }

    public void render(EntityStrawGolem entityIn, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn) {
        ModelStrawGolem golem = (ModelStrawGolem)this.func_217764_d();
        golem.setStatus(!entityIn.isHandEmpty(), entityIn.holdingFullBlock());
        Biome b = entityIn.field_70170_p.func_226691_t_(entityIn.func_180425_c());
        if (ConfigHelper.isShiverEnabled() && ((double)b.func_225486_c(entityIn.func_180425_c()) < 0.15 || entityIn.func_209511_p())) {
            double offX = entityIn.func_70681_au().nextDouble() / 32.0 - 0.015625;
            double offZ = entityIn.func_70681_au().nextDouble() / 32.0 - 0.015625;
            matrixStackIn.func_227861_a_(offX, 0.0, offZ);
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(EntityStrawGolem golem) {
        String name;
        int maxLifespan;
        int lifespan = golem.getCurrentLifespan();
        if (lifespan * 4 < (maxLifespan = ConfigHelper.getLifespan())) {
            return TEXTURE_DYING;
        }
        if (golem.func_145818_k_() && TEXTURE_MAP.containsKey(name = golem.func_145748_c_().getString().toLowerCase())) {
            return TEXTURE_MAP.get(name);
        }
        if (IS_DECEMBER) {
            return TEXTURE_WINTER;
        }
        return lifespan * 2 < maxLifespan ? TEXTURE_OLD : TEXTURE_DEFAULT;
    }

    @ParametersAreNonnullByDefault
    protected void renderName(EntityStrawGolem entityIn, String displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entityIn.func_145818_k_() || !TEXTURE_MAP.containsKey(entityIn.func_145748_c_().getString().toLowerCase())) {
            super.func_225629_a_((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    static {
        TEXTURE_DEFAULT = new ResourceLocation("strawgolem", "textures/entity/golem.png");
        TEXTURE_OLD = new ResourceLocation("strawgolem", "textures/entity/old_golem.png");
        TEXTURE_DYING = new ResourceLocation("strawgolem", "textures/entity/dying_golem.png");
        TEXTURE_WINTER = new ResourceLocation("strawgolem", "textures/entity/winter_golem.png");
        TEXTURE_MAP = new HashMap<String, ResourceLocation>();
        InputStream nameStream = Strawgolem.class.getResourceAsStream("/assets/strawgolem/textures/entity/customnames");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(nameStream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                String name = reader.readLine();
                ResourceLocation loc = new ResourceLocation("strawgolem", "textures/entity/" + name + ".png");
                TEXTURE_MAP.put(name, loc);
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        IS_DECEMBER = GregorianCalendar.getInstance().get(2) == 11;
    }
}

