/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public final class DimensionUtils {
    private static final Pattern NAME_PATTERN = Pattern.compile("^dim(ension)?_?");

    private DimensionUtils() {
    }

    public static boolean matches(DimensionType dimensionType, String input) {
        return dimensionType == DimensionUtils.from(input);
    }

    public static boolean containedInList(DimensionType dimensionType, Collection<? extends String> list, boolean valueIfListEmpty) {
        if (list.isEmpty()) {
            return valueIfListEmpty;
        }
        for (String string : list) {
            if (!DimensionUtils.matches(dimensionType, string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static DimensionType from(String str) {
        DimensionType type;
        if ("default".equalsIgnoreCase(str) || "overworld".equalsIgnoreCase(str)) {
            return DimensionType.field_223227_a_;
        }
        if ("nether".equalsIgnoreCase(str)) {
            return DimensionType.field_223228_b_;
        }
        if ("end".equalsIgnoreCase(str)) {
            return DimensionType.field_223229_c_;
        }
        ResourceLocation id = ResourceLocation.func_208304_a((String)str);
        if (id != null && (type = DimensionType.func_193417_a((ResourceLocation)id)) != null) {
            return type;
        }
        String trimmed = NAME_PATTERN.matcher(str).replaceFirst("");
        try {
            int k = Integer.parseInt(trimmed);
            return DimensionType.func_186069_a((int)k);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

