/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.text2speech.Narrator;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TaggableList;
import mcp.mobius.waila.api.impl.TaggedTextComponent;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaTickHandler {
    public static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public Tooltip tooltip = null;
    public MetaDataProvider handler = new MetaDataProvider();

    public void tickClient() {
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        ClientWorld world = client.field_71441_e;
        ClientPlayerEntity player = client.field_71439_g;
        if (client.field_195559_v == null) {
            return;
        }
        if (world != null && player != null) {
            RayTracing.INSTANCE.fire();
            RayTraceResult target = RayTracing.INSTANCE.getTarget();
            TaggableList<ResourceLocation, ITextComponent> currentTip = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
            TaggableList<ResourceLocation, ITextComponent> currentTipHead = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
            TaggableList<ResourceLocation, ITextComponent> currentTipBody = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
            TaggableList<ResourceLocation, ITextComponent> currentTipTail = new TaggableList<ResourceLocation, ITextComponent>(TaggedTextComponent::new);
            if (target != null && target.func_216346_c() == RayTraceResult.Type.BLOCK) {
                ItemStack targetStack;
                DataAccessor accessor = DataAccessor.INSTANCE;
                accessor.set((World)world, (PlayerEntity)player, target);
                accessor.stack = targetStack = RayTracing.INSTANCE.getTargetStack();
                if (!targetStack.func_190926_b()) {
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipHead, TooltipPosition.HEAD);
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipBody, TooltipPosition.BODY);
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipTail, TooltipPosition.TAIL);
                    this.combinePositions((PlayerEntity)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
                    this.tooltip = new Tooltip(currentTip, !targetStack.func_190926_b());
                }
            } else if (target != null && target.func_216346_c() == RayTraceResult.Type.ENTITY) {
                DataAccessor accessor = DataAccessor.INSTANCE;
                accessor.set((World)world, (PlayerEntity)player, target);
                Entity targetEnt = RayTracing.INSTANCE.getTargetEntity();
                if (targetEnt != null) {
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipHead, TooltipPosition.HEAD);
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipBody, TooltipPosition.BODY);
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipTail, TooltipPosition.TAIL);
                    this.combinePositions((PlayerEntity)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
                    ItemStack displayItem = RayTracing.INSTANCE.getIdentifierStack();
                    this.tooltip = new Tooltip(currentTip, !displayItem.func_190926_b());
                }
            }
        }
    }

    private void combinePositions(PlayerEntity player, List<ITextComponent> currentTip, List<ITextComponent> currentTipHead, List<ITextComponent> currentTipBody, List<ITextComponent> currentTipTail) {
        if (Waila.CONFIG.get().getGeneral().shouldShiftForDetails() && !currentTipBody.isEmpty() && !player.func_226563_dT_()) {
            currentTipBody.clear();
            currentTipBody.add(new TranslationTextComponent("tooltip.waila.sneak_for_details", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true))));
        }
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipHead);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipBody);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipTail);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onTooltip(WailaTooltipEvent event) {
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (WailaTickHandler.getNarrator().active() || !Waila.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
            return;
        }
        if (event.getAccessor().getBlock() == Blocks.field_150350_a && event.getAccessor().getEntity() == null) {
            return;
        }
        String narrate = event.getCurrentTip().get(0).func_150254_d();
        if (lastNarration.equalsIgnoreCase(narrate)) {
            return;
        }
        WailaTickHandler.getNarrator().clear();
        WailaTickHandler.getNarrator().say(narrate, true);
        lastNarration = narrate;
    }

    static {
        lastNarration = "";
    }
}

