/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDHandlerEntities
implements IEntityComponentProvider {
    static final IEntityComponentProvider INSTANCE = new HUDHandlerEntities();

    @Override
    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ((ITaggableList)tooltip).setTag(HUDHandlerBlocks.OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().func_150254_d())));
        if (config.get(PluginCore.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(HUDHandlerBlocks.REGISTRY_NAME_TAG, new StringTextComponent(accessor.getEntity().func_200600_R().getRegistryName().toString()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(PluginCore.CONFIG_SHOW_ENTITY_HEALTH) && accessor.getEntity() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)accessor.getEntity();
            float health = living.func_110143_aJ() / 2.0f;
            float maxHealth = living.func_110138_aP() / 2.0f;
            if (living.func_110138_aP() > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.health", new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                CompoundNBT healthData = new CompoundNBT();
                healthData.func_74776_a("health", health);
                healthData.func_74776_a("max", maxHealth);
                tooltip.add((ITextComponent)new RenderableTextComponent(PluginCore.RENDER_ENTITY_HEALTH, healthData));
            }
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModInfo(accessor.getEntity()).getName())));
    }
}

