/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;

public class NBTHelper {
    @Nullable
    private ItemStack stack;
    @Nullable
    private CompoundNBT tag;

    private NBTHelper(@Nullable CompoundNBT tag, @Nullable ItemStack stack) {
        this.stack = stack;
        this.tag = tag;
    }

    @Nullable
    public CompoundNBT getTag(String key) {
        return this.getTag(key, false);
    }

    public CompoundNBT getTag(String key, boolean createIfNull) {
        return this.getTagInternal(key, createIfNull, false);
    }

    private CompoundNBT getTagInternal(String key, boolean createIfNull, boolean ignoreLastNode) {
        if (this.tag == null) {
            if (createIfNull) {
                this.tag = new CompoundNBT();
                if (this.stack != null) {
                    this.stack.func_77982_d(this.tag);
                }
            } else {
                return null;
            }
        }
        if (key.isEmpty()) {
            return this.tag;
        }
        CompoundNBT subTag = this.tag;
        String[] parts = key.split("\\.");
        int length = parts.length;
        if (ignoreLastNode) {
            --length;
        }
        for (int i = 0; i < length; ++i) {
            if (!subTag.func_150297_b(parts[i], 10)) {
                if (createIfNull) {
                    subTag.func_218657_a(parts[i], (INBT)new CompoundNBT());
                } else {
                    return null;
                }
            }
            subTag = (CompoundNBT)subTag.func_74781_a(parts[i]);
        }
        return subTag;
    }

    private CompoundNBT getTagInternal(String key) {
        return this.getTagInternal(key, true, true);
    }

    private String getLastNode(String key) {
        int index = key.lastIndexOf(".");
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    public NBTHelper setTag(String key, INBT value) {
        this.getTagInternal(key).func_218657_a(this.getLastNode(key), value);
        return this;
    }

    public NBTHelper setInt(String key, int value) {
        this.getTagInternal(key).func_74768_a(this.getLastNode(key), value);
        return this;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 3)) {
            return subTag.func_74762_e(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setLong(String key, long value) {
        this.getTagInternal(key).func_74772_a(this.getLastNode(key), value);
        return this;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 4)) {
            return subTag.func_74763_f(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setShort(String key, short value) {
        this.getTagInternal(key).func_74777_a(this.getLastNode(key), value);
        return this;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 2)) {
            return subTag.func_74765_d(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setDouble(String key, double value) {
        this.getTagInternal(key).func_74780_a(this.getLastNode(key), value);
        return this;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 6)) {
            return subTag.func_74769_h(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setFloat(String key, float value) {
        this.getTagInternal(key).func_74776_a(this.getLastNode(key), value);
        return this;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 5)) {
            return subTag.func_74760_g(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setByte(String key, byte value) {
        this.getTagInternal(key).func_74776_a(this.getLastNode(key), (float)value);
        return this;
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 1)) {
            return subTag.func_74771_c(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setBoolean(String key, boolean value) {
        this.getTagInternal(key).func_74757_a(this.getLastNode(key), value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 1)) {
            return subTag.func_74767_n(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setPos(String key, BlockPos value) {
        this.getTagInternal(key).func_218657_a(this.getLastNode(key), (INBT)NBTUtil.func_186859_a((BlockPos)value));
        return this;
    }

    @Nullable
    public BlockPos getPos(String key) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 10)) {
            return NBTUtil.func_186861_c((CompoundNBT)this.getTag(actualKey));
        }
        return null;
    }

    public NBTHelper setGlobalPos(String key, GlobalPos value) {
        this.getTagInternal(key).func_218657_a(this.getLastNode(key), (INBT)value.func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
        return this;
    }

    @Nullable
    public GlobalPos getGlobalPos(String key) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 10)) {
            return GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.getTag(actualKey)));
        }
        return null;
    }

    public NBTHelper setBlockState(String key, BlockState value) {
        return this.setTag(key, (INBT)NBTUtil.func_190009_a((BlockState)value));
    }

    @Nullable
    public BlockState getBlockState(String key) {
        CompoundNBT subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return NBTUtil.func_190008_d((CompoundNBT)subTag);
        }
        return null;
    }

    public NBTHelper setGameProfile(String key, GameProfile value) {
        NBTUtil.func_180708_a((CompoundNBT)this.getTag(key, true), (GameProfile)value);
        return this;
    }

    @Nullable
    public GameProfile getGameProfile(String key) {
        CompoundNBT subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return NBTUtil.func_152459_a((CompoundNBT)subTag);
        }
        return null;
    }

    public NBTHelper setString(String key, String value) {
        this.getTagInternal(key).func_74778_a(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 8)) {
            return subTag.func_74779_i(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setIntArray(String key, int[] value) {
        this.getTagInternal(key).func_74783_a(this.getLastNode(key), value);
        return this;
    }

    public int[] getIntArray(String key) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 11)) {
            return subTag.func_74759_k(actualKey);
        }
        return new int[0];
    }

    public NBTHelper setByteArray(String key, byte[] value) {
        this.getTagInternal(key).func_74773_a(this.getLastNode(key), value);
        return this;
    }

    public byte[] getByteArray(String key) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 7)) {
            return subTag.func_74770_j(actualKey);
        }
        return new byte[0];
    }

    public NBTHelper setUUID(String key, UUID value) {
        this.getTagInternal(key).func_186854_a(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public UUID getUUID(String key) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (!(subTag == null || subTag.func_150297_b((actualKey = this.getLastNode(key)) + "Most", 4) && subTag.func_150297_b(actualKey + "Least", 4))) {
            return subTag.func_186857_a(actualKey);
        }
        return null;
    }

    public ListNBT getTagList(String key, int type) {
        String actualKey;
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.func_150297_b(actualKey = this.getLastNode(key), 9)) {
            return subTag.func_150295_c(actualKey, type);
        }
        return null;
    }

    public boolean hasTag(String key, int type) {
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            if (key.isEmpty()) {
                return true;
            }
            String actualKey = this.getLastNode(key);
            return subTag.func_150297_b(actualKey, type);
        }
        return false;
    }

    public Set<String> keySet(String key) {
        return this.hasTag(key, 10) ? this.getTag(key).func_150296_c() : Collections.EMPTY_SET;
    }

    public NBTHelper remove(String key) {
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            subTag.func_82580_o(actualKey);
        }
        return this;
    }

    public NBTHelper removeUUID(String key) {
        CompoundNBT subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            subTag.func_229681_c_(actualKey);
        }
        return this;
    }

    @Nullable
    public CompoundNBT get() {
        return this.tag;
    }

    public ItemStack getItem() {
        return this.stack == null ? ItemStack.field_190927_a : this.stack;
    }

    public static NBTHelper of(ItemStack stack) {
        return new NBTHelper(stack.func_77978_p(), stack);
    }

    public static NBTHelper of(CompoundNBT tag) {
        return new NBTHelper(tag, null);
    }

    public static NBTHelper create() {
        return new NBTHelper(null, null);
    }

    public static class NBT {
        public static final int END = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int INT = 3;
        public static final int LONG = 4;
        public static final int FLOAT = 5;
        public static final int DOUBLE = 6;
        public static final int BYTE_ARRAY = 7;
        public static final int STRING = 8;
        public static final int LIST = 9;
        public static final int COMPOUND = 10;
        public static final int INT_ARRAY = 11;
        public static final int LONG_ARRAY = 12;
        public static final int ANY_NUMERIC = 99;
    }
}

