/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import snownee.kiwi.schedule.ITicker;
import snownee.kiwi.schedule.Scheduler;
import snownee.kiwi.util.MutablePair;

public class WorldTicker
implements ITicker {
    private static final Map<DimensionType, MutablePair<WorldTicker>> tickers = Maps.newHashMap();
    @Nullable
    private World world;
    private final DimensionType dimensionType;

    public static WorldTicker get(World world, TickEvent.Phase phase) {
        return WorldTicker.get(world.field_73011_w.func_186058_p(), phase);
    }

    public static WorldTicker get(DimensionType dimensionType, TickEvent.Phase phase) {
        WorldTicker ticker;
        MutablePair<WorldTicker> pair = tickers.get(dimensionType);
        if (pair == null) {
            pair = new MutablePair();
            tickers.put(dimensionType, pair);
        }
        if ((ticker = pair.get(phase.ordinal())) == null) {
            ticker = new WorldTicker(dimensionType);
            pair.set(phase.ordinal(), ticker);
        }
        return ticker;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        MutablePair<WorldTicker> pair = tickers.get(event.world.field_73011_w.func_186058_p());
        if (pair == null) {
            return;
        }
        WorldTicker ticker = pair.get(event.phase.ordinal());
        if (ticker == null) {
            return;
        }
        ticker.world = event.world;
        Scheduler.tick(ticker);
    }

    @SubscribeEvent
    public static void unloadWorld(WorldEvent.Unload event) {
        MutablePair<WorldTicker> pair = tickers.get(event.getWorld().func_201672_e().field_73011_w.func_186058_p());
        if (pair == null) {
            return;
        }
        if (pair.left != null) {
            ((WorldTicker)pair.left).world = null;
        }
        if (pair.right != null) {
            ((WorldTicker)pair.right).world = null;
        }
    }

    private WorldTicker(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    public void destroy() {
        MutablePair<WorldTicker> pair = tickers.get(this.dimensionType);
        if (pair != null) {
            if (pair.left == this) {
                pair.left = null;
            }
            if (pair.right == this) {
                pair.left = null;
            }
        }
        this.world = null;
    }

    static {
        MinecraftForge.EVENT_BUS.register(WorldTicker.class);
    }
}

