/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class RGBA {
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public RGBA(int color) {
        this.red = color >> 24 & 0xFF;
        this.green = color >> 16 & 0xFF;
        this.blue = color >> 8 & 0xFF;
        this.alpha = color & 0xFF;
    }

    public RGBA(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public RGBA(float red, float green, float blue, float alpha) {
        this.red = (int)(red * 255.0f);
        this.green = (int)(green * 255.0f);
        this.blue = (int)(blue * 255.0f);
        this.alpha = (int)(alpha * 255.0f);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public float getRedComponent() {
        return (float)this.red / 255.0f;
    }

    public float getGreenComponent() {
        return (float)this.green / 255.0f;
    }

    public float getBlueComponent() {
        return (float)this.blue / 255.0f;
    }

    public float getAlphaComponent() {
        return (float)this.alpha / 255.0f;
    }

    public int getColor() {
        return (this.red & 0xFF) << 24 | (this.green & 0xFF) << 16 | (this.blue & 0xFF) << 8 | this.alpha & 0xFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void glColor() {
        GL11.glColor4f((float)this.getRedComponent(), (float)this.getGreenComponent(), (float)this.getBlueComponent(), (float)this.getAlphaComponent());
    }

    public String toString() {
        return "RGBA [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    public static RGBA fromARGB(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        return new RGBA(red, green, blue, alpha);
    }
}

