/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import info.u_team.u_team_core.util.MathUtil;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class LocateBiomeSubCommand {
    private static final DynamicCommandExceptionType FAILED_EXCEPTION = new DynamicCommandExceptionType(biomeName -> new TranslationTextComponent("commands.uteamcore.locatebiome.failed", new Object[]{biomeName}));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"locatebiome").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((context, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.BIOMES.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(context -> LocateBiomeSubCommand.locateBiome((CommandSource)context.getSource(), (ResourceLocation)context.getArgument("biome", ResourceLocation.class))));
    }

    private static int locateBiome(CommandSource source, ResourceLocation biomeName) throws CommandSyntaxException {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeName);
        if (biome == null) {
            throw FAILED_EXCEPTION.create((Object)biomeName);
        }
        ServerWorld world = source.func_197023_e();
        BiomeProvider biomeProvider = world.func_72863_F().func_201711_g().func_202090_b();
        Random random = new Random(world.func_72905_C());
        BlockPos pos = new BlockPos(source.func_197036_d());
        BlockPos foundPos = LocateBiomeSubCommand.findBiome(biomeProvider, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 6400, 8, biome, random, true);
        if (foundPos == null) {
            throw FAILED_EXCEPTION.create((Object)biomeName);
        }
        int distance = MathHelper.func_76141_d((float)MathUtil.getPlaneDistance(pos.func_177958_n(), pos.func_177952_p(), foundPos.func_177958_n(), foundPos.func_177952_p()));
        ITextComponent text = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{foundPos.func_177958_n(), "~", foundPos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + foundPos.func_177958_n() + " ~ " + foundPos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.locatebiome.success", new Object[]{biomeName, text, distance}), false);
        return distance;
    }

    private static BlockPos findBiome(BiomeProvider provider, int x, int y, int z, int radius, int accuracy, Biome biome, Random random, boolean randomPoint) {
        int j = x >> 2;
        int k = z >> 2;
        int l = radius >> 2;
        int m = y >> 2;
        int o = randomPoint ? 0 : l;
        BlockPos blockPos = null;
        int n = 0;
        for (int p = o; p <= l; p += accuracy) {
            for (int q = -p; q <= p; q += accuracy) {
                boolean bl2 = Math.abs(q) == p;
                for (int r = -p; r <= p; r += accuracy) {
                    int t;
                    int s;
                    if (randomPoint) {
                        boolean bl3;
                        boolean bl = bl3 = Math.abs(r) == p;
                        if (!bl3 && !bl2) continue;
                    }
                    if (biome != provider.func_225526_b_(s = j + r, m, t = k + q)) continue;
                    if (blockPos == null || random.nextInt(n + 1) == 0) {
                        blockPos = new BlockPos(s << 2, y, t << 2);
                        if (randomPoint) {
                            return blockPos;
                        }
                    }
                    ++n;
                }
            }
        }
        return blockPos;
    }
}

