/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.container.FluidContainer;
import info.u_team.u_team_core.container.FluidSlot;
import info.u_team.u_team_core.gui.render.FluidInventoryRender;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.FluidClickContainerMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public abstract class FluidContainerScreen<T extends Container>
extends ContainerScreen<T> {
    private static final FluidInventoryRender FLUID_RENDERER = new FluidInventoryRender();
    protected FluidInventoryRender fluidRenderer = FLUID_RENDERER;
    protected FluidSlot hoveredFluidSlot;

    public FluidContainerScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.field_147002_h instanceof FluidContainer) {
            this.hoveredFluidSlot = null;
            FluidContainer fluidContainer = (FluidContainer)this.field_147002_h;
            for (int index = 0; index < fluidContainer.fluidSlots.size(); ++index) {
                FluidSlot fluidSlot = fluidContainer.fluidSlots.get(index);
                if (!fluidSlot.isEnabled()) continue;
                this.drawFluidSlot(fluidSlot);
                if (!this.isFluidSlotSelected(fluidSlot, mouseX, mouseY)) continue;
                this.hoveredFluidSlot = fluidSlot;
                int x = fluidSlot.getX();
                int y = fluidSlot.getY();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int slotColor = this.getFluidSlotColor(index);
                this.fillGradient(x, y, x + 16, y + 16, slotColor, slotColor);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredFluidSlot != null && !this.hoveredFluidSlot.getStack().isEmpty()) {
            this.renderTooltip(this.getTooltipFromFluid(this.hoveredFluidSlot), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        FluidSlot fluidSlot;
        if (button == 0 && (fluidSlot = this.getSelectedFluidSlot(mouseX, mouseY)) != null) {
            if (!this.field_213127_e.func_70445_o().func_190926_b()) {
                UCoreNetwork.NETWORK.sendToServer((Object)new FluidClickContainerMessage(this.field_147002_h.field_75152_c, fluidSlot.slotNumber, FluidContainerScreen.hasShiftDown(), this.field_213127_e.func_70445_o()));
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void drawFluidSlot(FluidSlot fluidSlot) {
        this.fluidRenderer.drawFluid(fluidSlot.getX(), fluidSlot.getY(), fluidSlot.getStack());
    }

    protected boolean isFluidSlotSelected(FluidSlot fluidSlot, double mouseX, double mouseY) {
        return this.func_195359_a(fluidSlot.getX(), fluidSlot.getY(), 16, 16, mouseX, mouseY);
    }

    public int getFluidSlotColor(int index) {
        return super.getSlotColor(index);
    }

    public List<String> getTooltipFromFluid(FluidSlot fluidSlot) {
        FluidStack stack = fluidSlot.getStack();
        ArrayList<String> list = new ArrayList<String>();
        list.add(stack.getDisplayName().func_150254_d());
        list.add(new StringTextComponent(stack.getAmount() + " / " + fluidSlot.getSlotCapacity()).func_211708_a(TextFormatting.GRAY).func_150254_d());
        if (this.minecraft.field_71474_y.field_82882_x) {
            list.add(new StringTextComponent(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()).toString()).func_211708_a(TextFormatting.DARK_GRAY).func_150254_d());
        }
        return list;
    }

    private FluidSlot getSelectedFluidSlot(double mouseX, double mouseY) {
        if (this.field_147002_h instanceof FluidContainer) {
            FluidContainer fluidContainer = (FluidContainer)this.field_147002_h;
            for (int index = 0; index < fluidContainer.fluidSlots.size(); ++index) {
                FluidSlot fluidSlot = fluidContainer.fluidSlots.get(index);
                if (!this.isFluidSlotSelected(fluidSlot, mouseX, mouseY) || !fluidSlot.isEnabled()) continue;
                return fluidSlot;
            }
        }
        return null;
    }
}

