/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class CommonItemModelsProvider
extends ItemModelProvider {
    protected final Marker marker;
    protected final GenerationData data;
    protected final String modid;
    protected final DataGenerator generator;

    public CommonItemModelsProvider(GenerationData data) {
        super(data.getGenerator(), data.getModid(), data.getExistingFileHelper());
        this.data = data;
        this.modid = data.getModid();
        this.generator = data.getGenerator();
        this.marker = MarkerManager.getMarker((String)this.func_200397_b());
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.generatedModels.clear();
        this.registerModels();
        this.generatedModels.values().forEach(model -> {
            try {
                ResourceLocation location = model.getLocation();
                CommonProvider.write(cache, (JsonElement)model.toJson(), this.generator.func_200391_b().resolve("assets/" + location.func_110624_b() + "/models/" + location.func_110623_a() + ".json"));
            }
            catch (IOException ex) {
                CommonProvider.LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    public String func_200397_b() {
        return "Item-Models";
    }

    protected void simpleGenerated(IItemProvider provider) {
        this.simpleParent(provider, "item/generated");
    }

    protected void simpleHandheld(IItemProvider provider) {
        this.simpleParent(provider, "item/handheld");
    }

    protected void simpleParent(IItemProvider provider, String parent) {
        String registryPath = provider.func_199767_j().getRegistryName().func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(registryPath)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent))).texture("layer0", "item/" + registryPath);
    }

    protected void simpleBlock(Block block) {
        ResourceLocation registryName = block.getRegistryName();
        ((ItemModelBuilder)this.getBuilder(registryName.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(registryName.func_110624_b(), "block/" + registryName.func_110623_a())));
    }

    protected void iterateItems(Iterable<? extends Supplier<? extends Item>> iterable, Consumer<IItemProvider> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected void iterateBlocks(Iterable<? extends RegistryObject<? extends Block>> iterable, Consumer<IItemProvider> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected String getPath(IItemProvider provider) {
        return provider.func_199767_j().getRegistryName().func_110623_a();
    }
}

