/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Category;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Config;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ConfigData;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ConfigException;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Property;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class ConfigManager {
    private static final Map<Class<?>, ConfigData> CONFIGS = new HashMap();
    private static final List<Predicate<Field>> VERSION_CHECKERS = new ArrayList<Predicate<Field>>();
    private static boolean client = true;

    private ConfigManager() {
    }

    public static void setClient(boolean flag) {
        client = flag;
    }

    public static void registerVersionChecker(Predicate<Field> predicate) {
        VERSION_CHECKERS.add(predicate);
    }

    public static void register(Class<?> clazz) {
        Config config = clazz.getAnnotation(Config.class);
        if (config == null) {
            throw new ConfigException(clazz.getName() + " is not a configuration class");
        }
        String id = config.id();
        Object[] comment = config.comment();
        if (StringUtils.join((Object[])comment).trim().isEmpty()) {
            throw new ConfigException("Configuration comment may not be empty");
        }
        String pathData = config.path();
        String pathString = "config/" + (pathData.isEmpty() ? id : config.path()) + ".toml";
        Path path = Paths.get(pathString, new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ConfigException("Failed to create configuration directory", ex);
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        ConfigManager.loadCategories("", id + ".config.", "", clazz, categories);
        ConfigData data = new ConfigData((String[])comment, clazz, pathString, path, categories);
        CONFIGS.put(clazz, data);
        ConfigManager.reloadFromDisk(clazz);
    }

    public static void reloadFromDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        try {
            data.config.load();
        }
        catch (ParsingException ex) {
            ex.printStackTrace();
            data.config.entrySet().clear();
        }
        ConfigManager.reloadFromConfig(clazz);
    }

    public static void reloadFromConfig(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        for (Category category : data.categories) {
            for (Property property : category.properties) {
                if (!property.exists(data.config)) continue;
                String name = property.getFullyQualifiedName();
                try {
                    if (property.shouldLoad()) {
                        Object delayedLoad = data.delayedLoad.get(name);
                        if (delayedLoad != null) {
                            property.reloadDefault();
                            data.config.set(name, delayedLoad);
                            data.delayedLoad.remove(name);
                        }
                        property.deserialize(data.config);
                        continue;
                    }
                    data.delayedLoad.put(name, data.config.get(name));
                }
                catch (Exception ex) {
                    throw ConfigException.property(name, ex);
                }
            }
        }
        ConfigManager.writeToDisk(clazz);
    }

    public static void writeToDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        ArrayList<Object> subConfigs = new ArrayList<Object>();
        subConfigs.add(data.config);
        while (!subConfigs.isEmpty()) {
            int size = subConfigs.size();
            for (int i = 0; i < size; ++i) {
                for (CommentedConfig.Entry entry : ((CommentedConfig)subConfigs.get(i)).entrySet()) {
                    entry.removeComment();
                    Object raw = entry.getRawValue();
                    if (!(raw instanceof CommentedConfig)) continue;
                    subConfigs.add((CommentedConfig)raw);
                }
            }
            subConfigs.subList(0, size).clear();
        }
        for (Category category : data.categories) {
            category.initialize(data.config);
            category.onReload(false);
            if (client) {
                category.onReload(true);
            }
            for (Property property : category.properties) {
                String name = property.getFullyQualifiedName();
                try {
                    property.serialize(data.config);
                    Object delayedLoad = data.delayedLoad.get(name);
                    if (delayedLoad == null) continue;
                    data.config.set(name, delayedLoad);
                }
                catch (Exception ex) {
                    throw ConfigException.property(name, ex);
                }
            }
        }
        subConfigs.add(data.config);
        while (!subConfigs.isEmpty()) {
            int size = subConfigs.size();
            for (int i = 0; i < size; ++i) {
                CommentedConfig subConfig = (CommentedConfig)subConfigs.get(i);
                HashSet<String> toRemove = new HashSet<String>();
                for (CommentedConfig.Entry entry : subConfig.entrySet()) {
                    if (entry.getComment() == null) {
                        toRemove.add(entry.getKey());
                        continue;
                    }
                    Object raw = entry.getRawValue();
                    if (!(raw instanceof CommentedConfig)) continue;
                    subConfigs.add((CommentedConfig)raw);
                }
                toRemove.forEach(arg_0 -> ((CommentedConfig)subConfig).remove(arg_0));
            }
            subConfigs.subList(0, size).clear();
        }
        data.config.save();
        try {
            ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(data.path));
            lines.addAll(0, data.comment);
            Files.write(data.path, lines, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new ConfigException("Failed to write config", ex);
        }
    }

    public static CommentedFileConfig get(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).config;
    }

    public static String getPathString(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).pathString;
    }

    public static Path getPath(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).path;
    }

    private static void loadCategories(String fullyQualifiedNamePrefix, String languageKeyPrefix, String parentCategory, Class<?> clazz, List<Category> categories) {
        for (Field field : clazz.getDeclaredFields()) {
            Config.Category categoryData = field.getAnnotation(Config.Category.class);
            if (categoryData == null) continue;
            String comment = " " + StringUtils.join((Object[])categoryData.value(), (String)"\n ");
            if (comment.trim().isEmpty()) {
                throw new ConfigException("Category comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers))) {
                throw new ConfigException(name + " is not public static final");
            }
            boolean valid = true;
            for (Predicate<Field> predicate : VERSION_CHECKERS) {
                if (predicate.test(field)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            Class<?> categoryClass = field.getType();
            String categoryName = parentCategory + name;
            Category category = new Category(fullyQualifiedNamePrefix, languageKeyPrefix, categoryClass, comment, categoryName);
            ConfigManager.loadCategory(category);
            categories.add(category);
            ConfigManager.loadCategories(fullyQualifiedNamePrefix, languageKeyPrefix, categoryName + ".", categoryClass, categories);
        }
    }

    private static void loadCategory(Category category) {
        for (Field field : category.clazz.getDeclaredFields()) {
            Config.Property propertyData = field.getAnnotation(Config.Property.class);
            if (propertyData == null) continue;
            String comment = " " + StringUtils.join((Object[])propertyData.value(), (String)"\n ");
            if (comment.trim().isEmpty()) {
                throw new ConfigException("Property comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                throw new ConfigException(name + " is not public static non-final");
            }
            boolean valid = true;
            for (Predicate<Field> predicate : VERSION_CHECKERS) {
                if (predicate.test(field)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            Config.Previous previousData = field.getAnnotation(Config.Previous.class);
            String previous = previousData == null ? null : previousData.value();
            try {
                category.properties.add(new Property(category, name, field, comment, previous));
            }
            catch (RuntimeException ex) {
                throw new ConfigException(name, ex);
            }
        }
    }
}

