/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.hook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.forge.ForgeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class LivingEntityHook {
    private static final ImmutableMap<Pose, ImmutableList<Integer>> MINECART_POSE_Y = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    private static final Method SET_POSE = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_213301_b", (Class[])new Class[]{Pose.class});

    private LivingEntityHook() {
    }

    public static void dismountEntity(LivingEntity rider, Entity riding) {
        if (riding.func_70089_S() && rider.field_70170_p.func_180495_p(riding.func_180425_c()).func_185904_a() != Material.field_151567_E) {
            Vec3d pos = LivingEntityHook.getDismountPosition(rider, riding);
            rider.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        } else {
            rider.func_70634_a(riding.func_226277_ct_(), riding.func_226278_cu_() + (double)riding.func_213302_cg(), riding.func_226281_cx_());
        }
    }

    public static Vec3d getDismountPosition(Entity riding) {
        return new Vec3d(riding.func_226277_ct_(), riding.func_174813_aQ().field_72337_e, riding.func_226281_cx_());
    }

    public static Vec3d getDismountPosition(LivingEntity rider, Entity riding) {
        if (riding instanceof BoatEntity) {
            return LivingEntityHook.getDismountPosition(rider, (BoatEntity)riding);
        }
        if (riding instanceof MinecartEntity) {
            return LivingEntityHook.getDismountPosition(rider, (MinecartEntity)riding);
        }
        if (riding instanceof PigEntity) {
            return LivingEntityHook.getDismountPosition(rider, (PigEntity)riding);
        }
        return LivingEntityHook.getDismountPosition(riding);
    }

    public static Vec3d getDismountPosition(LivingEntity rider, BoatEntity boat) {
        double z;
        Vec3d xzDisplacement = LivingEntityHook.getXZDisplacement(boat.func_213311_cf() * MathHelper.field_180189_a, rider.func_213311_cf(), boat.field_70177_z);
        double x = boat.func_226277_ct_() + xzDisplacement.field_72450_a;
        BlockPos pos = new BlockPos(x, boat.func_174813_aQ().field_72337_e, z = boat.func_226281_cx_() + xzDisplacement.field_72449_c);
        if (boat.field_70170_p.func_201671_F(pos.func_177977_b())) {
            return LivingEntityHook.getDismountPosition((Entity)boat);
        }
        for (Pose pose : LivingEntityHook.getPoses((Entity)rider)) {
            Vec3d dismountPos;
            AxisAlignedBB boundingBox = LivingEntityHook.getBoundingBox((Entity)rider, pose);
            double yDisplacement = LivingEntityHook.getYDisplacement(boat.field_70170_p, pos);
            if (LivingEntityHook.isValidYDisplacement(yDisplacement) && LivingEntityHook.canDismount(rider.field_70170_p, (Entity)rider, boundingBox.func_191194_a(dismountPos = new Vec3d(x, (double)pos.func_177956_o() + yDisplacement, z)))) {
                LivingEntityHook.setPose((Entity)rider, pose);
                return dismountPos;
            }
            yDisplacement = LivingEntityHook.getYDisplacement(boat.field_70170_p, pos = pos.func_177977_b());
            if (!LivingEntityHook.isValidYDisplacement(yDisplacement) || !LivingEntityHook.canDismount(rider.field_70170_p, (Entity)rider, boundingBox.func_191194_a(dismountPos = new Vec3d(x, (double)pos.func_177956_o() + yDisplacement, z)))) continue;
            LivingEntityHook.setPose((Entity)rider, pose);
            return dismountPos;
        }
        return LivingEntityHook.getDismountPosition((Entity)boat);
    }

    public static Vec3d getDismountPosition(LivingEntity rider, MinecartEntity minecart) {
        Direction facing = minecart.func_184172_bi();
        if (facing.func_176740_k() == Direction.Axis.Y) {
            return LivingEntityHook.getDismountPosition((Entity)minecart);
        }
        int[][] offsets = LivingEntityHook.getOffsets(facing);
        BlockPos pos = minecart.func_180425_c();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Pose pose : LivingEntityHook.getPoses((Entity)rider)) {
            EntitySize size = rider.func_213305_a(pose);
            float f = Math.min(size.field_220315_a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)MINECART_POSE_Y.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i = (Integer)unmodifiableIterator.next();
                for (int[] offset : offsets) {
                    Vec3d dismountPos;
                    AxisAlignedBB boundingBox;
                    mutable.func_181079_c(pos.func_177958_n() + offset[0], pos.func_177956_o() + i, pos.func_177952_p() + offset[1]);
                    double yDisplacement = LivingEntityHook.getYDisplacement(minecart.field_70170_p, (BlockPos)mutable, state -> {
                        if (state.func_177230_c().isLadder(state, (IWorldReader)minecart.field_70170_p, pos, rider)) {
                            return true;
                        }
                        return state.func_177230_c() instanceof TrapDoorBlock && (Boolean)state.func_177229_b((IProperty)TrapDoorBlock.field_176283_b) != false;
                    });
                    if (!LivingEntityHook.isValidYDisplacement(yDisplacement) || !LivingEntityHook.canDismount(rider.field_70170_p, (Entity)rider, (boundingBox = new AxisAlignedBB((double)(-f), yDisplacement, (double)(-f), (double)f, yDisplacement + (double)size.field_220316_b, (double)f)).func_191194_a(dismountPos = new Vec3d((double)mutable.func_177958_n() + 0.5, (double)mutable.func_177956_o() + yDisplacement, (double)mutable.func_177952_p() + 0.5)))) continue;
                    LivingEntityHook.setPose((Entity)rider, pose);
                    return dismountPos;
                }
            }
        }
        return LivingEntityHook.getDismountPosition((Entity)minecart);
    }

    public static Vec3d getDismountPosition(LivingEntity rider, PigEntity pig) {
        Direction facing = pig.func_184172_bi();
        if (facing.func_176740_k() == Direction.Axis.Y) {
            return LivingEntityHook.getDismountPosition((Entity)pig);
        }
        int[][] offsets = LivingEntityHook.getOffsets(facing);
        BlockPos pos = pig.func_180425_c();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Pose pose : LivingEntityHook.getPoses((Entity)rider)) {
            AxisAlignedBB boundingBox = LivingEntityHook.getBoundingBox((Entity)rider, pose);
            for (int[] offset : offsets) {
                Vec3d dismountPos;
                mutable.func_181079_c(pos.func_177958_n() + offset[0], pos.func_177956_o(), pos.func_177952_p() + offset[1]);
                double yDisplacement = LivingEntityHook.getYDisplacement(pig.field_70170_p, (BlockPos)mutable);
                if (!LivingEntityHook.isValidYDisplacement(yDisplacement) || !LivingEntityHook.canDismount(rider.field_70170_p, (Entity)rider, boundingBox.func_191194_a(dismountPos = new Vec3d((double)mutable.func_177958_n() + 0.5, (double)mutable.func_177956_o() + yDisplacement, (double)mutable.func_177952_p() + 0.5)))) continue;
                LivingEntityHook.setPose((Entity)rider, pose);
                return dismountPos;
            }
        }
        return LivingEntityHook.getDismountPosition((Entity)pig);
    }

    public static Vec3d getXZDisplacement(double ridingWidth, double riderWidth, float ridingYaw) {
        double averageWidth = (ridingWidth + riderWidth) / 2.0;
        float sin = -MathHelper.func_76126_a((float)((float)((double)ridingYaw * Math.PI / 180.0)));
        float cos = MathHelper.func_76134_b((float)((float)((double)ridingYaw * Math.PI / 180.0)));
        float max = Math.max(Math.abs(sin), Math.abs(cos));
        return new Vec3d((double)sin * averageWidth / (double)max, 0.0, (double)cos * averageWidth / (double)max);
    }

    public static double getYDisplacement(World world, BlockPos pos) {
        return LivingEntityHook.getYDisplacement(world, pos, state -> false);
    }

    public static double getYDisplacement(World world, BlockPos pos, Predicate<BlockState> ignore) {
        VoxelShape shape;
        BlockState state = world.func_180495_p(pos);
        VoxelShape voxelShape = shape = ignore.test(state) ? VoxelShapes.func_197880_a() : state.func_196952_d((IBlockReader)world, pos);
        if (!shape.func_197766_b()) {
            return shape.func_197758_c(Direction.Axis.Y);
        }
        state = world.func_180495_p(pos = pos.func_177977_b());
        shape = ignore.test(state) ? VoxelShapes.func_197880_a() : state.func_196952_d((IBlockReader)world, pos);
        double end = shape.func_197758_c(Direction.Axis.Y);
        return end >= 1.0 ? end - 1.0 : Double.NEGATIVE_INFINITY;
    }

    public static boolean isValidYDisplacement(double displacement) {
        return !Double.isInfinite(displacement) && displacement < 1.0;
    }

    public static int[][] getOffsets(Direction facing) {
        Direction direction1 = facing.func_176746_e();
        Direction direction2 = direction1.func_176734_d();
        Direction direction3 = facing.func_176734_d();
        return new int[][]{{direction1.func_82601_c(), direction1.func_82599_e()}, {direction2.func_82601_c(), direction2.func_82599_e()}, {direction3.func_82601_c() + direction1.func_82601_c(), direction3.func_82599_e() + direction1.func_82599_e()}, {direction3.func_82601_c() + direction2.func_82601_c(), direction3.func_82599_e() + direction2.func_82599_e()}, {facing.func_82601_c() + direction1.func_82601_c(), facing.func_82599_e() + direction1.func_82599_e()}, {facing.func_82601_c() + direction2.func_82601_c(), facing.func_82599_e() + direction2.func_82599_e()}, {direction3.func_82601_c(), direction3.func_82599_e()}, {facing.func_82601_c(), facing.func_82599_e()}};
    }

    public static ImmutableList<Pose> getPoses(Entity entity) {
        return entity instanceof PlayerEntity ? ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING) : ImmutableList.of((Object)Pose.STANDING);
    }

    public static AxisAlignedBB getBoundingBox(Entity entity, Pose pose) {
        EntitySize size = entity.func_213305_a(pose);
        return new AxisAlignedBB((double)(-size.field_220315_a) / 2.0, 0.0, (double)(-size.field_220315_a) / 2.0, (double)size.field_220315_a / 2.0, (double)size.field_220316_b, (double)(size.field_220315_a / 2.0f));
    }

    public static boolean canDismount(World world, Entity entity, AxisAlignedBB boundingBox) {
        return world.func_226666_b_(entity, boundingBox).allMatch(VoxelShape::func_197766_b);
    }

    public static void setPose(Entity entity, Pose pose) {
        try {
            SET_POSE.invoke((Object)entity, pose);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ForgeUtils.crashReport("Failed to set pose", ex);
        }
    }
}

