/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.util;

import com.google.common.collect.ImmutableList;
import endergeticexpansion.common.world.EndergeticGenLayerBiome;
import endergeticexpansion.common.world.util.LazyAreaContextEndergetic;
import java.util.function.LongFunction;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class EndergeticLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createBiomeFactory(IAreaFactory<T> landFactory, LongFunction<C> contextFactory) {
        IAreaFactory biomeFactory = EndergeticGenLayerBiome.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomeFactory = LayerUtil.func_202829_a((long)100L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeFactory, (int)2, contextFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> createAreaFactories(WorldType worldType, LongFunction<C> contextFactory) {
        IAreaFactory landFactory = GenLayerLand.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        IAreaFactory biomesFactory = EndergeticLayerUtil.createBiomeFactory(landFactory, contextFactory);
        for (int i = 0; i < 3; ++i) {
            biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L + (long)i), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), biomesFactory);
        IAreaFactory voroniZoomBiomesFactory = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomesFactory);
        return ImmutableList.of((Object)biomesFactory, (Object)voroniZoomBiomesFactory, (Object)biomesFactory);
    }

    public static Layer[] createGenLayers(long seed, WorldType worldType) {
        ImmutableList factoryList = EndergeticLayerUtil.createAreaFactories(worldType, seedModifier -> new LazyAreaContextEndergetic(25, seed, seedModifier));
        Layer biomesLayer = new Layer((IAreaFactory)factoryList.get(0));
        Layer voroniZoomBiomesLayer = new Layer((IAreaFactory)factoryList.get(1));
        Layer biomesLayer2 = new Layer((IAreaFactory)factoryList.get(2));
        return new Layer[]{biomesLayer, voroniZoomBiomesLayer, biomesLayer2};
    }

    public static enum VoroniZoomLayer implements IAreaTransformer1
    {
        INSTANCE;


        public int func_215728_a(IExtendedNoiseRandom<?> p_215728_1_, IArea p_215728_2_, int p_215728_3_, int p_215728_4_) {
            int i = p_215728_3_ - 2;
            int j = p_215728_4_ - 2;
            int k = i >> 2;
            int l = j >> 2;
            int i1 = k << 2;
            int j1 = l << 2;
            p_215728_1_.func_202698_a((long)i1, (long)j1);
            double d0 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            double d1 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            p_215728_1_.func_202698_a((long)(i1 + 4), (long)j1);
            double d2 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            double d3 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            p_215728_1_.func_202698_a((long)i1, (long)(j1 + 4));
            double d4 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            double d5 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            p_215728_1_.func_202698_a((long)(i1 + 4), (long)(j1 + 4));
            double d6 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            double d7 = ((double)p_215728_1_.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            int k1 = i & 3;
            int l1 = j & 3;
            double d8 = ((double)l1 - d1) * ((double)l1 - d1) + ((double)k1 - d0) * ((double)k1 - d0);
            double d9 = ((double)l1 - d3) * ((double)l1 - d3) + ((double)k1 - d2) * ((double)k1 - d2);
            double d10 = ((double)l1 - d5) * ((double)l1 - d5) + ((double)k1 - d4) * ((double)k1 - d4);
            double d11 = ((double)l1 - d7) * ((double)l1 - d7) + ((double)k1 - d6) * ((double)k1 - d6);
            if (d8 < d9 && d8 < d10 && d8 < d11) {
                return p_215728_2_.func_202678_a(this.func_215721_a(i1), this.func_215722_b(j1));
            }
            if (d9 < d8 && d9 < d10 && d9 < d11) {
                return p_215728_2_.func_202678_a(this.func_215721_a(i1 + 4), this.func_215722_b(j1)) & 0xFF;
            }
            return d10 < d8 && d10 < d9 && d10 < d11 ? p_215728_2_.func_202678_a(this.func_215721_a(i1), this.func_215722_b(j1 + 4)) : p_215728_2_.func_202678_a(this.func_215721_a(i1 + 4), this.func_215722_b(j1 + 4)) & 0xFF;
        }

        public int func_215721_a(int p_215721_1_) {
            return p_215721_1_ >> 2;
        }

        public int func_215722_b(int p_215722_1_) {
            return p_215722_1_ >> 2;
        }
    }

    public static enum GenLayerLand implements IAreaTransformer0
    {
        INSTANCE;


        public int func_215735_a(INoiseRandom random, int x, int z) {
            return 1;
        }
    }
}

