/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import endergeticexpansion.core.registry.EEItems;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSetCooldownMessage {
    private String itemName;
    private int cooldown;
    boolean isVest;

    public SSetCooldownMessage() {
    }

    public SSetCooldownMessage(ItemStack stack, int cooldown, boolean isVest) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            this.itemName = stack.func_77977_a();
        }
        this.cooldown = cooldown;
        this.isVest = isVest;
    }

    public void fromBytes(PacketBuffer buf) {
        this.itemName = buf.func_150789_c(0x1FFFFFFF);
        this.cooldown = buf.readInt();
        this.isVest = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.itemName);
        buf.writeInt(this.cooldown);
        buf.writeBoolean(this.isVest);
    }

    public static void serialize(SSetCooldownMessage message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SSetCooldownMessage deserialize(PacketBuffer packet) {
        SSetCooldownMessage message = new SSetCooldownMessage();
        message.fromBytes(packet);
        return message;
    }

    public static void handle(SSetCooldownMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> {
                ItemStack vest;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (message.isVest && !(vest = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && vest.func_77973_b() == EEItems.BOOFLO_VEST.get()) {
                    player.func_184811_cZ().func_185145_a(vest.func_77973_b(), SSetCooldownMessage.getDelayForBoofedAmount(vest));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static int getDelayForBoofedAmount(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("timesBoofed") < 5) {
                return 7;
            }
            if (stack.func_77978_p().func_74762_e("timesBoofed") > 4) {
                return (int)(0.5 * (double)stack.func_77978_p().func_74762_e("timesBoofed") * 20.0);
            }
        }
        return 20;
    }
}

