/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import endergeticexpansion.api.entity.util.EntityMotionHelper;
import endergeticexpansion.common.entities.BoofBlockEntity;
import endergeticexpansion.common.entities.PoiseClusterEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SBoofEntityMessage {
    private float xzForce;
    private float yForce;
    private int radius;

    public SBoofEntityMessage(float xzForce, float upperForce, int radius) {
        this.xzForce = xzForce;
        this.yForce = upperForce;
        this.radius = radius;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeFloat(this.xzForce);
        buf.writeFloat(this.yForce);
        buf.writeInt(this.radius);
    }

    public static SBoofEntityMessage deserialize(PacketBuffer buf) {
        float xzForce = buf.readFloat();
        float yForce = buf.readFloat();
        int radius = buf.readInt();
        return new SBoofEntityMessage(xzForce, yForce, radius);
    }

    public static void handle(SBoofEntityMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                for (Entity entity : player.func_130014_f_().func_217357_a(Entity.class, player.func_174813_aQ().func_186662_g((double)message.radius))) {
                    if (entity == player || entity instanceof BoofBlockEntity || entity instanceof PaintingEntity || entity instanceof PoiseClusterEntity || entity instanceof ItemFrameEntity) continue;
                    boolean reverse = player.func_184187_bx() == entity;
                    EntityMotionHelper.knockbackEntity(entity, message.xzForce, message.yForce, reverse, false);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

