/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.puffbug.ai;

import endergeticexpansion.api.entity.util.RayTraceHelper;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class PuffBugAttackGoal
extends Goal {
    public static final float SHOOT_RANGE = 8.0f;
    private final PuffBugEntity puffbug;
    @Nullable
    private Path path;
    private int delayCounter;
    private int ticksChased;

    public PuffBugAttackGoal(PuffBugEntity puffbug) {
        this.puffbug = puffbug;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity target = this.puffbug.func_70638_az();
        if (target == null) {
            return false;
        }
        if (!PuffBugEntity.CAN_ANGER.test(target)) {
            return false;
        }
        if (!this.puffbug.isInflated()) {
            return false;
        }
        Path newPath = this.puffbug.func_70661_as().func_75494_a((Entity)target, 0);
        if (newPath != null) {
            this.path = newPath;
        }
        return !this.puffbug.func_184218_aH() && this.puffbug.getLaunchDirection() == null && this.path != null;
    }

    public void func_75249_e() {
        this.puffbug.func_70661_as().func_75484_a(this.path, 2.5);
        this.puffbug.func_213395_q(true);
        this.delayCounter = 0;
        this.ticksChased = 0;
    }

    public boolean func_75253_b() {
        if (!this.puffbug.isInflated()) {
            return false;
        }
        return this.puffbug.getLaunchDirection() == null && this.puffbug.func_70638_az() != null && PuffBugEntity.CAN_ANGER.test(this.puffbug.func_70638_az());
    }

    public void func_75246_d() {
        --this.delayCounter;
        ++this.ticksChased;
        LivingEntity target = this.puffbug.func_70638_az();
        this.puffbug.func_70671_ap().func_75651_a((Entity)target, 20.0f, 20.0f);
        if (this.delayCounter <= 0) {
            Path path = this.puffbug.func_70661_as().func_179680_a(target.func_180425_c().func_177981_b(4), 4);
            if (path != null && this.puffbug.func_70661_as().func_75484_a(path, 3.5)) {
                this.delayCounter += 5;
            }
            if (this.puffbug.func_70032_d((Entity)target) <= 8.0f) {
                Vec3d distance = new Vec3d(target.func_226277_ct_() - this.puffbug.func_226277_ct_(), target.func_226278_cu_() - this.puffbug.func_226278_cu_(), target.func_226281_cx_() - this.puffbug.func_226281_cx_());
                float pitch = -((float)(MathHelper.func_181159_b((double)distance.func_82617_b(), (double)MathHelper.func_76133_a((double)(distance.func_82615_a() * distance.func_82615_a() + distance.func_82616_c() * distance.func_82616_c()))) * 57.2957763671875));
                float yaw = (float)(MathHelper.func_181159_b((double)distance.func_82616_c(), (double)distance.func_82615_a()) * 57.2957763671875) - 90.0f;
                double startingDistance = 8.0;
                startingDistance *= startingDistance;
                RayTraceResult blockTrace = this.traceBlocks(MathHelper.func_76142_g((float)pitch), yaw);
                if (blockTrace != null) {
                    startingDistance = blockTrace.func_216347_e().func_72436_e(this.puffbug.func_174824_e(1.0f));
                }
                EntityRayTraceResult rayTrace = RayTraceHelper.rayTraceEntityResult((Entity)this.puffbug, MathHelper.func_76142_g((float)pitch), yaw, 8.0, startingDistance, 1.0f);
                if (this.ticksChased >= 30 && this.canFitNewCollisionShape() && rayTrace != null && rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK && pitch > 30.0f) {
                    this.puffbug.setLaunchDirection(MathHelper.func_76142_g((float)pitch), yaw);
                    this.puffbug.func_70661_as().func_75499_g();
                }
            }
        }
    }

    public void func_75251_c() {
        LivingEntity target = this.puffbug.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.puffbug.func_70624_b(null);
        }
        this.puffbug.func_213395_q(false);
        this.puffbug.func_70661_as().func_75499_g();
    }

    private boolean canFitNewCollisionShape() {
        return this.puffbug.func_70631_g_() ? this.puffbug.field_70170_p.func_226664_a_(this.getBoundingBoxForSize(PuffBugEntity.PROJECTILE_SIZE_CHILD).func_72317_d(0.0, (double)0.225f, 0.0)) : this.puffbug.field_70170_p.func_226664_a_(this.getBoundingBoxForSize(PuffBugEntity.PROJECTILE_SIZE).func_72317_d(0.0, (double)0.225f, 0.0));
    }

    private AxisAlignedBB getBoundingBoxForSize(EntitySize size) {
        float f = size.field_220315_a / 2.0f;
        Vec3d vec3d = new Vec3d(this.puffbug.func_226277_ct_() - (double)f, this.puffbug.func_226278_cu_(), this.puffbug.func_226281_cx_() - (double)f);
        Vec3d vec3d1 = new Vec3d(this.puffbug.func_226277_ct_() + (double)f, this.puffbug.func_226278_cu_() + (double)size.field_220316_b, this.puffbug.func_226281_cx_() + (double)f);
        return new AxisAlignedBB(vec3d, vec3d1);
    }

    public RayTraceResult traceBlocks(float pitch, float yaw) {
        Vec3d eyeVec = this.puffbug.func_174824_e(1.0f);
        Vec3d lookVec = RayTraceHelper.getVectorForRotation(pitch, yaw);
        Vec3d vec3d2 = eyeVec.func_72441_c(lookVec.func_82615_a() * 8.0, lookVec.func_82617_b() * 8.0, lookVec.func_82616_c() * 8.0);
        return this.puffbug.field_70170_p.func_217299_a(new RayTraceContext(eyeVec, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.puffbug));
    }
}

