/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities;

import com.teamabnormals.abnormals_core.core.utils.MathUtils;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import endergeticexpansion.common.blocks.poise.PoiseClusterBlock;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EESounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PoiseClusterEntity
extends LivingEntity {
    private static final int MAX_BLOCKS_TO_MOVE_UP = 30;
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(PoiseClusterEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> BLOCKS_TO_MOVE_UP = EntityDataManager.func_187226_a(PoiseClusterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIMES_HIT = EntityDataManager.func_187226_a(PoiseClusterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ASCEND = EntityDataManager.func_187226_a(PoiseClusterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean playedSound;

    public PoiseClusterEntity(EntityType<? extends PoiseClusterEntity> cluster, World worldIn) {
        super((EntityType)EEEntities.POISE_CLUSTER.get(), worldIn);
    }

    public PoiseClusterEntity(World worldIn, BlockPos origin, double x, double y, double z) {
        this((EntityType<? extends PoiseClusterEntity>)((EntityType)EEEntities.POISE_CLUSTER.get()), worldIn);
        this.func_70606_j(100.0f);
        this.setOrigin(new BlockPos((Vec3i)origin));
        this.func_70107_b(x + 0.5, y, z + 0.5);
        this.func_189654_d(true);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BLOCKS_TO_MOVE_UP, (Object)0);
        this.field_70180_af.func_187214_a(TIMES_HIT, (Object)0);
        this.field_70180_af.func_187214_a(ASCEND, (Object)true);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74772_a("OriginPos", this.getOrigin().func_218275_a());
        nbt.func_74768_a("BlocksToMoveUp", this.getBlocksToMoveUp());
        nbt.func_74768_a("TimesHit", this.getTimesHit());
        nbt.func_74757_a("IsAscending", this.isAscending());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setOrigin(BlockPos.func_218283_e((long)nbt.func_74763_f("OriginPos")));
        this.setBlocksToMoveUp(nbt.func_74762_e("BlocksToMoveUp"));
        this.setTimesHit(nbt.func_74762_e("TimesHit"));
        this.setAscending(nbt.func_74767_n("IsAscending"));
    }

    public void func_70071_h_() {
        boolean hasEntity;
        this.moveEntitiesUp(false);
        super.func_70071_h_();
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70177_z = 180.0f;
        if (this.func_226278_cu_() + 1.0 < (double)(this.getOrigin().func_177956_o() + this.getBlocksToMoveUp()) && this.isAscending()) {
            this.func_213293_j(0.0, 0.05f, 0.0);
        }
        if (this.func_226278_cu_() + 1.0 >= (double)(this.getOrigin().func_177956_o() + this.getBlocksToMoveUp())) {
            if (!this.field_70170_p.field_72995_K) {
                this.setAscending(false);
            }
            this.setBlocksToMoveUp(0);
        }
        if (!this.isAscending()) {
            if (this.func_226278_cu_() > (double)this.getOrigin().func_177956_o()) {
                this.func_213293_j(0.0, -0.05f, 0.0);
            } else if (Math.ceil(this.func_226278_cu_()) == (double)this.getOrigin().func_177956_o() && this.field_70173_aa > 10) {
                for (int i = 0; i < 8; ++i) {
                    double offsetX = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                    double offsetZ = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                    double x = (double)this.getOrigin().func_177958_n() + 0.5 + offsetX;
                    double y = (double)this.getOrigin().func_177956_o() + 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    double z = (double)this.getOrigin().func_177952_p() + 0.5 + offsetZ;
                    if (!this.func_70613_aW()) continue;
                    NetworkUtil.spawnParticle((String)"endergetic:short_poise_bubble", (double)x, (double)y, (double)z, (double)(MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.1f), (Random)this.field_70146_Z) + (double)0.025f), (double)(this.field_70146_Z.nextFloat() * 0.15f + 0.1f), (double)(MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.1f), (Random)this.field_70146_Z) + (double)0.025f));
                }
                this.field_70170_p.func_175656_a(this.getOrigin(), ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
                this.func_70106_y();
            }
            if (this.isBlockBlockingPath(true) && this.field_70173_aa > 10) {
                BlockPos pos = this.func_180425_c();
                for (int i = 0; i < 8; ++i) {
                    double offsetX = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                    double offsetZ = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                    double x = (double)pos.func_177958_n() + 0.5 + offsetX;
                    double y = (double)pos.func_177956_o() + 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    double z = (double)pos.func_177952_p() + 0.5 + offsetZ;
                    if (!this.func_70613_aW()) continue;
                    NetworkUtil.spawnParticle((String)"endergetic:short_poise_bubble", (double)x, (double)y, (double)z, (double)(MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.1f), (Random)this.field_70146_Z) + (double)0.025f), (double)(this.field_70146_Z.nextFloat() * 0.15f + 0.1f), (double)(MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.1f), (Random)this.field_70146_Z) + (double)0.025f));
                }
                this.field_70170_p.func_175656_a(pos, ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_176223_P());
                this.func_70106_y();
            }
        }
        AxisAlignedBB bb = this.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0);
        List entities = this.func_130014_f_().func_217357_a(Entity.class, bb);
        int entityCount = entities.size();
        boolean bl = hasEntity = entityCount > 0;
        if (hasEntity && this.isAscending()) {
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                if (entity instanceof PoiseClusterEntity) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.setAscending(false);
                    }
                    this.setBlocksToMoveUp(0);
                }
                entity.field_70143_R = 0.0f;
            }
        }
        if (this.isAscending()) {
            if (this.field_70167_r == this.func_226278_cu_() && this.isBlockBlockingPath(false)) {
                this.descentCluster();
            }
            if (this.field_70167_r == this.func_226278_cu_() && this.field_70173_aa % 25 == 0 && this.func_226278_cu_() + 1.0 >= (double)(this.getOrigin().func_177956_o() + this.getBlocksToMoveUp())) {
                this.descentCluster();
            }
        }
        if (this.getBlocksToMoveUp() > 30) {
            this.setBlocksToMoveUp(30);
        }
        this.func_195061_cb();
        this.func_70066_B();
        if (this.func_110143_aJ() != 0.0f) {
            this.func_70606_j(100.0f);
        }
        if (!this.field_70170_p.field_72995_K && !this.playedSound) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
            this.playedSound = true;
        }
        this.moveEntitiesUp(true);
    }

    public boolean func_85031_j(Entity entityIn) {
        this.setTimesHit(this.getTimesHit() + 1);
        if (this.getTimesHit() >= 3) {
            if (!this.field_70170_p.field_72995_K) {
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)new ItemStack((IItemProvider)EEBlocks.POISE_CLUSTER.get()));
            }
            this.func_70106_y();
            return true;
        }
        this.setAscending(true);
        this.setBlocksToMoveUp((int)(Math.ceil(this.func_226278_cu_()) - (double)this.getOrigin().func_177956_o()) + 10);
        return false;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_76352_a()) {
            this.setTimesHit(this.getTimesHit() + 1);
            if (this.getTimesHit() >= 3) {
                if (!this.func_130014_f_().field_72995_K) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)new ItemStack((IItemProvider)EEBlocks.POISE_CLUSTER.get()));
                }
                this.func_70106_y();
            }
            if ((int)(Math.ceil(this.func_226278_cu_()) - (double)this.getOrigin().func_177956_o()) + 10 < 30) {
                this.setAscending(true);
                this.setBlocksToMoveUp((int)(Math.ceil(this.func_226278_cu_()) - (double)this.getOrigin().func_177956_o()) + 10);
            } else {
                this.func_70106_y();
            }
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PoiseClusterSound(this));
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)EESounds.CLUSTER_BREAK.get();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b;
    }

    private boolean isBlockBlockingPath(boolean down) {
        Vec3d eyePos = down ? this.func_213303_ch() : this.func_174824_e(1.0f);
        return this.field_70170_p.func_217299_a(new RayTraceContext(eyePos, eyePos.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private void moveEntitiesUp(boolean afterTick) {
        AxisAlignedBB clusterBB;
        List entitiesAbove;
        if (this.func_213322_ci().func_72433_c() > 0.0 && this.isAscending() && !(entitiesAbove = this.field_70170_p.func_72839_b(null, clusterBB = this.func_174813_aQ().func_72317_d(0.0, (double)0.01f, 0.0))).isEmpty()) {
            for (int i = 0; i < entitiesAbove.size(); ++i) {
                Entity entity = (Entity)entitiesAbove.get(i);
                if (entity.func_184218_aH() || entity instanceof PoiseClusterEntity || entity instanceof PlayerEntity && !afterTick || entity.func_184192_z() == PushReaction.IGNORE) continue;
                AxisAlignedBB entityBB = entity.func_174813_aQ();
                double distanceMotion = clusterBB.field_72337_e - entityBB.field_72338_b + (double)(entity instanceof PlayerEntity ? 0.0225f : 0.02f);
                if (entity instanceof PlayerEntity) {
                    entity.func_213315_a(MoverType.PISTON, new Vec3d(0.0, distanceMotion, 0.0));
                } else {
                    entity.func_213315_a(MoverType.SELF, new Vec3d(0.0, distanceMotion, 0.0));
                }
                entity.field_70122_E = true;
            }
        }
    }

    protected void descentCluster() {
        if (!this.field_70170_p.field_72995_K) {
            this.setAscending(false);
        }
        this.setBlocksToMoveUp(0);
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public void setBlocksToMoveUp(int value) {
        this.field_70180_af.func_187227_b(BLOCKS_TO_MOVE_UP, (Object)value);
    }

    public int getBlocksToMoveUp() {
        return (Integer)this.field_70180_af.func_187225_a(BLOCKS_TO_MOVE_UP);
    }

    protected void setTimesHit(int hits) {
        this.field_70180_af.func_187227_b(TIMES_HIT, (Object)hits);
    }

    protected int getTimesHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIMES_HIT);
    }

    protected void setAscending(boolean acscending) {
        this.field_70180_af.func_187227_b(ASCEND, (Object)acscending);
    }

    public boolean isAscending() {
        return (Boolean)this.field_70180_af.func_187225_a(ASCEND);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223225_d_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected float func_189749_co() {
        return 0.0f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70081_e(int amount) {
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @OnlyIn(value=Dist.CLIENT)
    private class PoiseClusterSound
    extends TickableSound {
        private final PoiseClusterEntity cluster;
        private int ticksRemoved;

        protected PoiseClusterSound(PoiseClusterEntity cluster) {
            super((SoundEvent)EESounds.POISE_CLUSTER_AMBIENT.get(), SoundCategory.NEUTRAL);
            this.cluster = cluster;
            this.field_147659_g = true;
            this.field_147665_h = 0;
            this.field_147662_b = 1.0f;
            this.field_147660_d = (float)cluster.func_226277_ct_();
            this.field_147661_e = (float)cluster.func_226278_cu_();
            this.field_147658_f = (float)cluster.func_226281_cx_();
            this.field_147663_c = cluster.func_70681_au().nextFloat() * 0.3f + 0.8f;
        }

        public boolean func_211503_n() {
            return true;
        }

        public void func_73660_a() {
            if (this.cluster.func_70089_S()) {
                this.field_147660_d = (float)this.cluster.func_226277_ct_();
                this.field_147661_e = (float)this.cluster.func_226278_cu_();
                this.field_147658_f = (float)this.cluster.func_226281_cx_();
            } else {
                ++this.ticksRemoved;
                if (this.ticksRemoved > 10) {
                    this.field_147668_j = true;
                }
            }
            this.field_147662_b = Math.max(0.0f, this.field_147662_b - (float)this.ticksRemoved / 10.0f);
        }
    }
}

