/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import com.google.common.collect.Maps;
import endergeticexpansion.core.events.PlayerEvents;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class CorrockBlock
extends Block {
    private static final Map<DimensionType, Supplier<Block>> CONVERSIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), conversions -> {
        conversions.put(DimensionType.field_223227_a_, () -> (Block)EEBlocks.CORROCK_OVERWORLD_BLOCK.get());
        conversions.put(DimensionType.field_223228_b_, () -> (Block)EEBlocks.CORROCK_NETHER_BLOCK.get());
        conversions.put(DimensionType.field_223229_c_, () -> (Block)EEBlocks.CORROCK_END_BLOCK.get());
    });
    public final boolean petrified;

    public CorrockBlock(Block.Properties properties, boolean petrified) {
        super(properties);
        this.petrified = petrified;
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!this.petrified && !this.isInProperDimension((World)world)) {
            world.func_175656_a(pos, ((Block)((Supplier)CONVERSIONS.getOrDefault(world.func_201675_m().func_186058_p(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get()).func_176223_P());
        }
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SoundType.field_211383_n;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        if (this.isSubmerged(worldIn, currentPos)) {
            return !this.petrified ? PlayerEvents.convertCorrockBlock(stateIn) : stateIn;
        }
        return stateIn;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        return this.func_176223_P();
    }

    public boolean isInProperDimension(World world) {
        return !this.petrified && ((Supplier)CONVERSIONS.getOrDefault(world.func_201675_m().func_186058_p(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get() == this;
    }

    public boolean isSubmerged(IWorld world, BlockPos pos) {
        for (Direction offsets : Direction.values()) {
            IFluidState fluidState = world.func_204610_c(pos.func_177972_a(offsets));
            if (fluidState.func_206888_e() || !fluidState.func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }
}

