/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.misc.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SelfPlanting
extends Feature {
    private ForgeConfigSpec.IntValue despawnTime;
    private ForgeConfigSpec.IntValue chanceToPlant;
    private ForgeConfigSpec.BooleanValue selfPlanting;

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.selfPlanting = builder.translation("config.vanillatweaks:selfPlanting").comment("Want seeds to auto-plant themselves when broken?").define("selfPlanting", true);
        this.despawnTime = builder.translation("config.vanillatweaks:despawnTime").comment("How long a plant should take to despawn (and attempt to plant) Default Minecraft is 6000.").defineInRange("despawnTime", 1000, 0, Integer.MAX_VALUE);
        this.chanceToPlant = builder.translation("config.vanillatweaks:chanceToPlant").comment("Percentage chance to plant").defineInRange("chanceToPlant", 100, 0, 100);
    }

    @SubscribeEvent
    public void itemDecay(ItemExpireEvent event) {
        this.plant(event.getEntityItem());
    }

    @SubscribeEvent
    public void itemToss(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)event.getEntity();
            Item item = itemEntity.func_92059_d().func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if (((Boolean)this.selfPlanting.get()).booleanValue() && item instanceof BlockItem && block instanceof IPlantable && !(block instanceof FlowerBlock)) {
                itemEntity.lifespan = (Integer)this.despawnTime.get();
            }
        }
    }

    public void plant(ItemEntity entity) {
        World world = entity.func_130014_f_();
        ItemStack stack = entity.func_92059_d().func_77946_l();
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        BlockPos entityPos = new BlockPos((Entity)entity);
        if (((Boolean)this.selfPlanting.get()).booleanValue() && item instanceof BlockItem && block instanceof IPlantable && !(block instanceof FlowerBlock) && world.field_73012_v.nextInt() > (Integer)this.chanceToPlant.get()) {
            Vec3d entityVec;
            BlockRayTraceResult rayTraceResult;
            FakePlayer player = Utils.getFakePlayer(world);
            ActionResultType result = item.func_195939_a(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, rayTraceResult = entity.field_70170_p.func_217299_a(new RayTraceContext((entityVec = new Vec3d((double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p())).func_72441_c(0.0, 2.0, 0.0), entityVec.func_72441_c(0.0, -1.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity))));
            if (result == ActionResultType.SUCCESS && stack.func_190916_E() > 0) {
                stack.func_190918_g(1);
            }
            if (stack.func_190916_E() > 0) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)entityPos.func_177958_n(), (double)(entityPos.func_177956_o() + 1), (double)entityPos.func_177952_p(), stack));
            }
        }
    }
}

