/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks.silkspawner;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.tweaks.silkspawner.DummySpawnerLogic;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SilkSpawner
extends Feature {
    private static final String SPAWNER_TAG = "SilkSpawnerData";
    private static Item mobSpawnerItem = null;
    private ForgeConfigSpec.BooleanValue enableSilkSpawner;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableSilkSpawner = builder.translation("config.vanillatweaks:enableSilkSpawner").comment("Want the ability to move spawners with silk touch?").define("enableSilkSpawner", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).func_184600_cs() != null) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
            ItemStack mainHand = playerEntity.func_184614_ca();
            ItemStack offHand = playerEntity.func_184592_cb();
            ItemStack stack = null;
            if (mainHand.func_77973_b() == mobSpawnerItem) {
                stack = mainHand;
            } else if (offHand.func_77973_b() == mobSpawnerItem) {
                stack = offHand;
            }
            if (((Boolean)this.enableSilkSpawner.get()).booleanValue() && stack != null && stack.func_77942_o()) {
                TileEntity tile;
                CompoundNBT stackTag = stack.func_77978_p();
                assert (stackTag != null);
                CompoundNBT spawnerDataNBT = stackTag.func_74775_l(SPAWNER_TAG);
                if (!spawnerDataNBT.isEmpty() && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)tile).func_145881_a().func_98270_a(spawnerDataNBT);
                }
            }
        }
    }

    @Override
    public void setup() {
        mobSpawnerItem = Blocks.field_150474_ac.func_199767_j();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreak(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        TileEntity tile = world.func_175625_s(event.getPos());
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)event.getPlayer().func_184614_ca());
        if (event.getState().func_177230_c() instanceof SpawnerBlock && !world.func_201670_d() && tile instanceof MobSpawnerTileEntity && ((Boolean)this.enableSilkSpawner.get()).booleanValue() && lvl >= 1) {
            event.setExpToDrop(0);
            ItemStack drop = new ItemStack((IItemProvider)Blocks.field_150474_ac);
            CompoundNBT spawnerData = ((MobSpawnerTileEntity)tile).func_145881_a().func_189530_b(new CompoundNBT());
            CompoundNBT stackTag = new CompoundNBT();
            spawnerData.func_82580_o("Delay");
            stackTag.func_218657_a(SPAWNER_TAG, (INBT)spawnerData);
            drop.func_77982_d(stackTag);
            Block.func_180635_a((World)tile.func_145831_w(), (BlockPos)event.getPos(), (ItemStack)drop);
            tile.func_145831_w().func_175713_t(tile.func_174877_v());
            world.func_175655_b(event.getPos(), false);
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="vanillatweaks", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onToolTipEvent(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (stack.func_77942_o()) {
                CompoundNBT stackTag = stack.func_77978_p();
                assert (stackTag != null);
                CompoundNBT spawnerDataNBT = stackTag.func_74775_l(SilkSpawner.SPAWNER_TAG);
                if (!spawnerDataNBT.isEmpty()) {
                    DummySpawnerLogic.DUMMY_SPAWNER_LOGIC.func_98270_a(spawnerDataNBT);
                    Entity ent = DummySpawnerLogic.DUMMY_SPAWNER_LOGIC.func_184994_d();
                    event.getToolTip().add(ent.func_145748_c_());
                }
            }
        }
    }
}

