/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import com.google.common.collect.Maps;
import io.github.strikerrocker.vt.base.Feature;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FurnaceBrokenXP
extends Feature {
    private ForgeConfigSpec.BooleanValue furnaceBrokenXP;

    private static void spawnXp(World world, int size, float xp, BlockPos pos) {
        int value;
        if (xp == 0.0f) {
            size = 0;
        } else if (xp < 1.0f) {
            value = MathHelper.func_76141_d((float)((float)size * xp));
            if (value < MathHelper.func_76123_f((float)((float)size * xp)) && Math.random() < (double)((float)size * xp - (float)value)) {
                ++value;
            }
            size = value;
        }
        while (size > 0) {
            value = ExperienceOrbEntity.func_70527_a((int)size);
            size -= value;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, value));
        }
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.furnaceBrokenXP = builder.translation("config.vanillatweaks:furnaceBrokenXP").comment("Want furnace to drop stored xp when broken?").define("furnaceBrokenXP", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        TileEntity blockEntity;
        World world = event.getPlayer().field_70170_p;
        BlockPos pos = event.getPos();
        if (((Boolean)this.furnaceBrokenXP.get()).booleanValue() && world.func_180495_p(pos).func_177230_c() instanceof AbstractFurnaceBlock && (blockEntity = world.func_175625_s(pos)) instanceof AbstractFurnaceTileEntity && !world.func_201670_d()) {
            HashMap recipesUsed = Maps.newHashMap();
            CompoundNBT tag = new CompoundNBT();
            tag = blockEntity.func_189515_b(tag);
            for (int i = 0; i < tag.func_74765_d("RecipesUsedSize"); ++i) {
                ResourceLocation identifier_1 = new ResourceLocation(tag.func_74779_i("RecipeLocation" + i));
                int recipeAmt = tag.func_74762_e("RecipeAmount" + i);
                recipesUsed.put(identifier_1, recipeAmt);
            }
            for (Map.Entry map : recipesUsed.entrySet()) {
                world.func_199532_z().func_215367_a((ResourceLocation)map.getKey()).ifPresent(recipe_1 -> FurnaceBrokenXP.spawnXp(world, (Integer)map.getValue(), ((AbstractCookingRecipe)recipe_1).func_222138_b(), pos));
            }
        }
    }
}

