/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VeteranEnchantment
extends Enchantment {
    VeteranEnchantment(String name) {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.ARMOR_HEAD, new EquipmentSlotType[]{EquipmentSlotType.HEAD});
        this.setRegistryName(name);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (((Boolean)EnchantmentFeature.enableVeteran.get()).booleanValue() && event.world != null && !event.world.func_201670_d()) {
            ServerWorld world = (ServerWorld)event.world;
            world.func_217482_a(EntityType.field_200807_u, EntityPredicates.field_94557_a).forEach(this::attemptToMove);
        }
    }

    private void attemptToMove(Entity entity) {
        double zDiff;
        double yDiff;
        double xDiff;
        double movementFactor;
        double invertedMovementFactor;
        double range = 32.0;
        PlayerEntity closestPlayer = entity.field_70170_p.func_217362_a(entity, range);
        if (closestPlayer != null && EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)closestPlayer.func_184582_a(EquipmentSlotType.HEAD)) > 0 && (invertedMovementFactor = 1.0 - (movementFactor = Math.sqrt((xDiff = (double)(closestPlayer.func_180425_c().func_177958_n() - entity.func_180425_c().func_177958_n()) / range) * xDiff + (yDiff = (double)((float)closestPlayer.func_180425_c().func_177956_o() + closestPlayer.func_70047_e() - (float)entity.func_180425_c().func_177956_o()) / range) * yDiff + (zDiff = (double)(closestPlayer.func_180425_c().func_177952_p() - entity.func_180425_c().func_177952_p()) / range) * zDiff))) > 0.0) {
            invertedMovementFactor *= invertedMovementFactor;
            Vec3d motion = entity.func_213322_ci();
            entity.func_213293_j(motion.field_72450_a + xDiff / movementFactor * invertedMovementFactor * 0.1, motion.field_72448_b + yDiff / movementFactor * invertedMovementFactor * 0.1, motion.field_72449_c + zDiff / movementFactor * invertedMovementFactor * 0.1);
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10;
    }

    public int func_223551_b(int enchantmentLevel) {
        return 40;
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableVeteran.get() != false ? 1 : 0;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_().equals((Object)EquipmentSlotType.HEAD) && (Boolean)EnchantmentFeature.enableVeteran.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableVeteran.get();
    }
}

