/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HomingEnchantment
extends Enchantment {
    private AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    HomingEnchantment(String name) {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.BOW, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.setRegistryName(name);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && !event.world.func_201670_d() && ((Boolean)EnchantmentFeature.enableHoming.get()).booleanValue()) {
            ServerWorld world = (ServerWorld)event.world;
            world.func_217482_a(EntityType.field_200790_d, EntityPredicates.field_94557_a).forEach(entity -> this.attemptToMove((Entity)entity, world));
        }
    }

    private void attemptToMove(Entity arrowEntity, ServerWorld world) {
        AbstractArrowEntity arrow = (AbstractArrowEntity)arrowEntity;
        LivingEntity shooter = (LivingEntity)arrow.func_212360_k();
        if (shooter != null && EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca()) > 0) {
            int homingLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)shooter.func_184614_ca());
            double distance = Math.pow(2.0, (double)homingLevel - 1.0) * 32.0;
            List livingEntities = world.getEntities().collect(Collectors.toList());
            LivingEntity target = null;
            for (Entity entity : livingEntities) {
                double distanceToArrow = entity.func_70032_d((Entity)arrow);
                if (!(entity instanceof LivingEntity) || !(distanceToArrow < distance) || !shooter.func_70685_l(entity) || entity.func_110124_au().equals(shooter.func_110124_au())) continue;
                distance = distanceToArrow;
                target = (LivingEntity)entity;
            }
            if (target != null) {
                double x = target.func_180425_c().func_177958_n() - arrow.func_180425_c().func_177958_n();
                double y = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - (double)((float)arrow.func_180425_c().func_177956_o() + arrow.func_213302_cg() / 2.0f);
                double z = target.func_180425_c().func_177952_p() - arrow.func_180425_c().func_177952_p();
                arrow.func_70186_c(x, y, z, (float)Math.sqrt(Math.pow(2.0, arrow.func_213322_ci().field_72450_a) + Math.pow(2.0, arrow.func_213322_ci().field_72448_b) + Math.pow(2.0, arrow.func_213322_ci().field_72449_c)), 0.0f);
            }
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return (enchantmentLevel - 1) * 10 + 10;
    }

    public int func_223551_b(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableHoming.get() != false ? 3 : 0;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof BowItem && (Boolean)EnchantmentFeature.enableHoming.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableHoming.get();
    }
}

