/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import com.google.common.collect.Maps;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.enchantments.BlazingEnchantment;
import io.github.strikerrocker.vt.enchantments.HomingEnchantment;
import io.github.strikerrocker.vt.enchantments.HopsEnchantment;
import io.github.strikerrocker.vt.enchantments.NimbleEnchantment;
import io.github.strikerrocker.vt.enchantments.SiphonEnchantment;
import io.github.strikerrocker.vt.enchantments.VeteranEnchantment;
import io.github.strikerrocker.vt.enchantments.VigorEnchantment;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentFeature
extends Feature {
    static ForgeConfigSpec.BooleanValue enableBlazing;
    static ForgeConfigSpec.BooleanValue enableHops;
    static ForgeConfigSpec.BooleanValue enableNimble;
    static ForgeConfigSpec.BooleanValue enableSiphon;
    static ForgeConfigSpec.BooleanValue enableVeteran;
    static ForgeConfigSpec.BooleanValue enableVigor;
    static ForgeConfigSpec.BooleanValue enableHoming;
    public static Map<String, Tuple<Enchantment, String>> enchantments;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enableBlazing = builder.translation("config.vanillatweaks:enableBlazing").comment(this.getComment("blazing")).define("enableBlazing", true);
        enableHops = builder.translation("config.vanillatweaks:enableHops").comment(this.getComment("hops")).define("enableHops", true);
        enableNimble = builder.translation("config.vanillatweaks:enableNimble").comment(this.getComment("nimble")).define("enableNimble", true);
        enableSiphon = builder.translation("config.vanillatweaks:enableSiphon").comment(this.getComment("siphon")).define("enableSiphon", true);
        enableVeteran = builder.translation("config.vanillatweaks:enableVeteran").comment(this.getComment("veteran")).define("enableVeteran", true);
        enableVigor = builder.translation("config.vanillatweaks:enableVigor").comment(this.getComment("vigor")).define("enableVigor", true);
        enableHoming = builder.translation("config.vanillatweaks:enableHoming").comment(this.getComment("homing")).define("enableHoming", true);
    }

    private String getComment(String name) {
        return (String)enchantments.get(name).func_76340_b();
    }

    static {
        enchantments = Maps.newHashMap();
        enchantments.put("blazing", (Tuple<Enchantment, String>)new Tuple((Object)new BlazingEnchantment("blazing"), (Object)"Want to smelt things when you mine them?"));
        enchantments.put("hops", (Tuple<Enchantment, String>)new Tuple((Object)new HopsEnchantment("hops"), (Object)"Want to jump more than a block high with an enchantment?"));
        enchantments.put("nimble", (Tuple<Enchantment, String>)new Tuple((Object)new NimbleEnchantment("nimble"), (Object)"Want more speed with an enchantment?"));
        enchantments.put("siphon", (Tuple<Enchantment, String>)new Tuple((Object)new SiphonEnchantment("siphon"), (Object)"Don't want the zombies stealing your items when you are mining?"));
        enchantments.put("veteran", (Tuple<Enchantment, String>)new Tuple((Object)new VeteranEnchantment("veteran"), (Object)"Want all the experience in the nearby area?"));
        enchantments.put("vigor", (Tuple<Enchantment, String>)new Tuple((Object)new VigorEnchantment("vigor"), (Object)"Want more health with an enchant?"));
        enchantments.put("homing", (Tuple<Enchantment, String>)new Tuple((Object)new HomingEnchantment("homing"), (Object)"Don't want to aim but love shooting arrows?"));
        enchantments.forEach((name, tuple) -> MinecraftForge.EVENT_BUS.register(tuple.func_76341_a()));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEnchantments(RegistryEvent.Register<Enchantment> registryEvent) {
            enchantments.values().forEach(triple -> registryEvent.getRegistry().register((IForgeRegistryEntry)triple.func_76341_a()));
        }

        @SubscribeEvent
        public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)new BlazingEnchantment.Serializer().setRegistryName("vanillatweaks", "blazing"));
            event.getRegistry().register((IForgeRegistryEntry)new SiphonEnchantment.Serializer().setRegistryName("vanillatweaks", "siphon"));
        }
    }
}

