/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import com.google.gson.JsonObject;
import io.github.strikerrocker.vt.enchantments.EnchantmentFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlazingEnchantment
extends Enchantment {
    BlazingEnchantment(String name) {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.DIGGER, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.setRegistryName(name);
    }

    public int func_77325_b() {
        return (Boolean)EnchantmentFeature.enableBlazing.get() != false ? 1 : 0;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 15;
    }

    public int func_223551_b(int enchantmentLevel) {
        return 61;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185306_r;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ToolItem && (Boolean)EnchantmentFeature.enableBlazing.get() != false;
    }

    public boolean isAllowedOnBooks() {
        return (Boolean)EnchantmentFeature.enableBlazing.get();
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BlazingModifier> {
        public BlazingModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new BlazingModifier(conditionsIn);
        }
    }

    private static class BlazingModifier
    extends LootModifier {
        public BlazingModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        private static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g()).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)((ItemStack)context.func_216031_c(LootParameters.field_216289_i)));
            if (enchantments.containsKey(Enchantments.field_185308_t) && enchantments.containsKey(EnchantmentFeature.enchantments.get("blazing").func_76341_a())) {
                return generatedLoot;
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            generatedLoot.forEach(stack -> ret.add(BlazingModifier.smelt(stack, context)));
            return ret;
        }
    }
}

