/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.content.blocks;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.content.blocks.BlockConditions;
import io.github.strikerrocker.vt.content.blocks.CharcoalBlock;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalBlock;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalContainer;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalScreen;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalTileEntity;
import io.github.strikerrocker.vt.content.blocks.pedestal.PedestalTileEntityRenderer;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class Blocks
extends Feature {
    public static final Block PEDESTAL_BLOCK = new PedestalBlock();
    private static final CharcoalBlock CHARCOAL_BLOCK = new CharcoalBlock("charcoalblock");
    private static final Block SUGAR_BLOCK = (Block)new Block(Block.Properties.func_200949_a((Material)Material.field_151595_p, (MaterialColor)MaterialColor.field_193561_M).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)).setRegistryName("sugarblock");
    private static final Block FLINT_BLOCK = (Block)new Block(Block.Properties.func_200949_a((Material)Material.field_151595_p, (MaterialColor)MaterialColor.field_151650_B).func_200948_a(1.0f, 10.0f)).setRegistryName("flintblock");
    @ObjectHolder(value="vanillatweaks:pedestal")
    public static TileEntityType<PedestalTileEntity> PEDESTAL_TYPE;
    static ForgeConfigSpec.BooleanValue enableStorageBlocks;
    static ForgeConfigSpec.BooleanValue enablePedestal;
    private static Block[] blocks;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        enablePedestal = builder.translation("config.vanillatweaks:enablePedestal").comment("Want to showcase your treasure but item frame doesn't satisfy you?").define("enablePedestal", true);
        enableStorageBlocks = builder.translation("config.vanillatweaks:enableStorageBlocks").comment("Want block forms of flint, charcoal and sugar?").define("enableStorageBlocks", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item == CHARCOAL_BLOCK.func_199767_j()) {
            event.setBurnTime(16000);
        }
        if (item == net.minecraft.block.Blocks.field_150478_aa.func_199767_j()) {
            event.setBurnTime(400);
        }
    }

    static {
        blocks = new Block[]{CHARCOAL_BLOCK, SUGAR_BLOCK, FLINT_BLOCK, PEDESTAL_BLOCK};
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterItemBlocks(RegistryEvent.Register<Item> event) {
            Arrays.stream(blocks).map(block -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName(block.getRegistryName())).forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        }

        @SubscribeEvent
        public static void onRegisterContainers(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new PedestalContainer(windowId, inv, data.func_179259_c())).setRegistryName("vanillatweaks", "pedestal"));
        }

        @SubscribeEvent
        public static void onRegisterTEType(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(PedestalTileEntity::new, (Block[])new Block[]{PEDESTAL_BLOCK}).func_206865_a(null).setRegistryName(new ResourceLocation("vanillatweaks", "pedestal")));
        }

        @SubscribeEvent
        public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            CraftingHelper.register((IConditionSerializer)BlockConditions.Serializer.INSTANCE);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ScreenManager.func_216911_a(PedestalContainer.TYPE, PedestalScreen::new);
            ClientRegistry.bindTileEntityRenderer(PEDESTAL_TYPE, PedestalTileEntityRenderer::new);
        }
    }
}

