/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.base;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.config.ModConfig;

public abstract class Module {
    private ForgeConfigSpec.Builder configBuilder;
    private Map<String, Feature> features = new HashMap<String, Feature>();
    private String name;
    private String comments;
    private ForgeConfigSpec forgeConfigSpec;

    public Module(String name, String comments, boolean requiresMCRestart, ForgeConfigSpec.Builder configBuilder) {
        this.name = name;
        this.comments = comments;
        this.configBuilder = configBuilder;
        this.addFeatures();
        this.setupConfig();
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.forgeConfigSpec;
    }

    public void setConfigSpec(ForgeConfigSpec forgeConfigSpec) {
        this.forgeConfigSpec = forgeConfigSpec;
    }

    public abstract void addFeatures();

    public void setup() {
        this.features.values().stream().filter(Feature::usesEvents).forEach(feature -> {
            MinecraftForge.EVENT_BUS.register(feature);
            VanillaTweaks.LOGGER.debug("Registered Event Handler for class " + feature.getClass().getName());
        });
        this.features.values().forEach(Feature::setup);
    }

    public void configChanged(ModConfig.ModConfigEvent event) {
        this.features.values().forEach(feature -> feature.configChanged(event));
    }

    public void setupConfig() {
        this.configBuilder.comment(this.comments).push(this.name);
        this.features.values().forEach(feature -> feature.setupConfig(this.configBuilder));
        this.configBuilder.pop();
    }

    protected void registerFeature(String name, Feature feature) {
        this.features.put(name, feature);
        feature.setName(name);
        feature.setModule(this);
    }

    public Feature getFeature(String name) {
        return this.features.get(name);
    }

    public String getName() {
        return this.name;
    }
}

