/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt;

import io.github.strikerrocker.vt.base.Module;
import io.github.strikerrocker.vt.content.ContentModule;
import io.github.strikerrocker.vt.enchantments.EnchantmentModule;
import io.github.strikerrocker.vt.loot.LootModule;
import io.github.strikerrocker.vt.recipes.RecipeModule;
import io.github.strikerrocker.vt.tweaks.TweaksModule;
import io.github.strikerrocker.vt.world.WorldModule;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vanillatweaks")
public class VanillaTweaks {
    public static final Logger LOGGER = LogManager.getLogger();
    private static List<Module> modules = new ArrayList<Module>();

    public VanillaTweaks() {
        VanillaTweaks.registerModules();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::configChanged);
    }

    private static void registerModules() {
        ArrayList moduleBuilder = new ArrayList();
        Collections.addAll(moduleBuilder, ContentModule::new, EnchantmentModule::new, LootModule::new, RecipeModule::new, TweaksModule::new, WorldModule::new);
        for (Function function : moduleBuilder) {
            Pair specPair = new ForgeConfigSpec.Builder().configure(function);
            modules.add((Module)specPair.getLeft());
            Path cfgFile = FMLPaths.CONFIGDIR.get().resolve("vanillatweaks").resolve(((Module)specPair.getLeft()).getName() + ".toml");
            String cfgStr = cfgFile.toString();
            if (cfgStr.length() > 128) {
                cfgStr = "vanillatweaks-" + ((Module)specPair.getLeft()).getName() + ".toml";
            } else {
                try {
                    Files.createDirectories(cfgFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ((Module)specPair.getLeft()).setConfigSpec((ForgeConfigSpec)specPair.getRight());
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)specPair.getRight(), cfgStr);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        modules.forEach(Module::setup);
        LOGGER.info("Setup Complete");
    }

    private void configChanged(ModConfig.ModConfigEvent event) {
        modules.forEach(module -> module.configChanged(event));
    }
}

