/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.util;

import net.minecraft.util.math.MathHelper;

public class BiomeWeightTable {
    private final int radius;
    private final int diameter;
    private final float[] table;

    public BiomeWeightTable(int radius) {
        this.radius = radius;
        this.diameter = radius * 2 + 1;
        this.table = new float[this.diameter * this.diameter];
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                float weight = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
                int arrayX = x + radius;
                int arrayZ = z + radius;
                this.table[arrayX + arrayZ * this.diameter] = weight;
            }
        }
    }

    public float get(int x, int z) {
        return this.table[x + this.radius + (z + this.radius) * this.diameter];
    }

    public int getRadius() {
        return this.radius;
    }
}

