/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.template;

import com.mushroom.midnight.common.world.template.TemplateCompiler;
import com.mushroom.midnight.common.world.template.TemplateMarkerProcessor;
import com.mushroom.midnight.common.world.template.TemplateMarkers;
import com.mushroom.midnight.common.world.template.TemplatePostProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class CompiledTemplate {
    public final ResourceLocation templateId;
    private final Template template;
    public final PlacementSettings settings;
    public final BlockPos origin;
    private final TemplateMarkerProcessor markerProcessor;
    private final Collection<TemplatePostProcessor> postProcessors;
    public final TemplateMarkers markers;

    CompiledTemplate(ResourceLocation templateId, Template template, PlacementSettings settings, BlockPos origin, TemplateMarkerProcessor markerProcessor, Collection<TemplatePostProcessor> postProcessors) {
        this.templateId = templateId;
        this.template = template;
        this.settings = settings;
        this.origin = origin;
        this.markerProcessor = markerProcessor;
        this.postProcessors = postProcessors;
        this.markers = TemplateCompiler.compileMarkers(origin, settings, template);
    }

    public void addTo(IWorld world, Random random, int flags) {
        this.template.func_189962_a(world, this.origin, this.settings, flags);
        this.markers.forEachReplacement((pos, state) -> world.func_180501_a(pos, state, flags));
        if (this.markerProcessor != null) {
            this.markers.forEach((marker, pos) -> this.markerProcessor.process(world, (BlockPos)pos, (String)marker));
        }
        if (!this.postProcessors.isEmpty()) {
            List blocks = Template.func_215387_a((IWorld)world, (BlockPos)this.origin, (PlacementSettings)this.settings, (List)this.settings.func_227459_a_(this.template.field_204769_a, this.origin));
            for (TemplatePostProcessor processor : this.postProcessors) {
                for (Template.BlockInfo info : blocks) {
                    processor.process(this, world, random, info.field_186242_a, info.field_186243_b);
                }
            }
        }
    }

    public String toString() {
        return "CompiledTemplate{template=" + this.templateId + ", origin=" + this.origin + '}';
    }
}

