/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.generator;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightFluids;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class MidnightCaveCarver
extends CaveWorldCarver {
    private final float radiusScale;

    public MidnightCaveCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> deserialize, float radiusScale) {
        super(deserialize, 256);
        this.radiusScale = radiusScale;
        this.field_222718_j = ImmutableSet.of((Object)MidnightBlocks.NIGHTSTONE, (Object)MidnightBlocks.DIRT, (Object)MidnightBlocks.GRASS_BLOCK);
        this.field_222719_k = ImmutableSet.of((Object)MidnightFluids.FLOWING_MIASMA);
    }

    protected int func_222726_b(Random random) {
        return random.nextInt(random.nextInt(80) + 8);
    }

    protected boolean func_225556_a_(IChunk chunk, Function<BlockPos, Biome> biomeFunc, BitSet carvingMask, Random rand, BlockPos.Mutable mutable, BlockPos.Mutable p_225556_6_, BlockPos.Mutable p_225556_7_, int p_225556_8_, int p_225556_9_, int p_225556_10_, int x, int z, int p_225556_13_, int y, int p_225556_15_, AtomicBoolean p_225556_16_) {
        int i = p_225556_13_ | p_225556_15_ << 4 | y << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        mutable.func_181079_c(x, y, z);
        boolean noAdjacentBlock = true;
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN) continue;
            mutable.func_189536_c(dir);
            if (this.doesAdjacentBlockPreventCarving(chunk.func_180495_p((BlockPos)mutable), mutable.func_177956_o() <= 10)) {
                noAdjacentBlock = false;
            }
            mutable.func_189534_c(dir, -1);
            if (!noAdjacentBlock) break;
        }
        if (this.func_222706_a(chunk.func_180495_p((BlockPos)mutable)) && noAdjacentBlock) {
            chunk.func_177436_a((BlockPos)mutable, y <= 10 ? MidnightBlocks.MIASMA.func_176223_P() : field_222715_g, false);
            return true;
        }
        return false;
    }

    protected boolean doesAdjacentBlockPreventCarving(BlockState state, boolean miasmaHeight) {
        if (miasmaHeight && state.func_177230_c() == MidnightBlocks.MIASMA) {
            return false;
        }
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i || miasmaHeight && material == Material.field_151579_a;
    }

    protected boolean func_222706_a(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150357_h) {
            return false;
        }
        Material material = state.func_185904_a();
        return (material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b) && material != Material.field_151586_h && material != Material.field_151587_i;
    }

    protected boolean func_222707_a(BlockState state, BlockState aboveState) {
        if (state.func_177230_c() == Blocks.field_150357_h) {
            return false;
        }
        Material material = state.func_185904_a();
        Material aboveMaterial = aboveState.func_185904_a();
        return (material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b) && material != Material.field_151586_h && material != Material.field_151587_i && aboveMaterial != Material.field_151586_h && aboveMaterial != Material.field_151587_i;
    }

    protected float func_222722_a(Random random) {
        return super.func_222722_a(random) * this.radiusScale;
    }
}

