/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.tree;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.world.AbstractWrappedWorld;
import com.mushroom.midnight.common.world.feature.tree.AbstractMidnightTreeFeature;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.common.IPlantable;

public abstract class MidnightTreeFeature
extends AbstractMidnightTreeFeature<NoFeatureConfig> {
    protected MidnightTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize);
        this.setSapling((IPlantable)MidnightBlocks.SHADOWROOT_SAPLING);
    }

    protected abstract boolean place(IWorld var1, Random var2, BlockPos var3);

    @Override
    protected final boolean place(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos origin, MutableBoundingBox bounds) {
        WorldWrapper wrapper = new WorldWrapper((IWorld)world, changedBlocks, bounds);
        boolean result = this.place(wrapper, random, origin);
        if (bounds.field_78897_a > bounds.field_78893_d) {
            bounds.field_78892_f = 0;
            bounds.field_78894_e = 0;
            bounds.field_78893_d = 0;
            bounds.field_78896_c = 0;
            bounds.field_78895_b = 0;
            bounds.field_78897_a = 0;
        }
        return result;
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double radius) {
        return this.produceBlob(origin, radius, radius);
    }

    protected Set<BlockPos> produceBlob(BlockPos origin, double horizontalRadius, double verticalRadius) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        int verticalRadiusCeil = MathHelper.func_76143_f((double)verticalRadius);
        int horizontalRadiusCeil = MathHelper.func_76143_f((double)horizontalRadius);
        BlockPos minPos = origin.func_177982_a(-horizontalRadiusCeil, -verticalRadiusCeil, -horizontalRadiusCeil);
        BlockPos maxPos = origin.func_177982_a(horizontalRadiusCeil, verticalRadiusCeil, horizontalRadiusCeil);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minPos, (BlockPos)maxPos)) {
            double deltaZ;
            double deltaY;
            double deltaX = (double)(pos.func_177958_n() - origin.func_177958_n()) / horizontalRadius;
            double distanceSquared = deltaX * deltaX + (deltaY = (double)(pos.func_177956_o() - origin.func_177956_o()) / verticalRadius) * deltaY + (deltaZ = (double)(pos.func_177952_p() - origin.func_177952_p()) / horizontalRadius) * deltaZ;
            if (!(distanceSquared <= 1.0)) continue;
            positions.add(pos.func_185334_h());
        }
        return positions;
    }

    protected static boolean canGrowInto(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.isAir((IBlockReader)world, pos) || state.func_203425_a(BlockTags.field_206952_E) || AbstractMidnightTreeFeature.isDirt((IWorldGenerationBaseReader)world, pos) || !state.func_200015_d((IBlockReader)world, pos));
    }

    private static class WorldWrapper
    extends AbstractWrappedWorld {
        private final Set<BlockPos> logs;
        private final MutableBoundingBox bounds;

        private WorldWrapper(IWorld world, Set<BlockPos> logs, MutableBoundingBox bounds) {
            super(world);
            this.logs = logs;
            this.bounds = bounds;
        }

        @Override
        public boolean func_180501_a(BlockPos pos, BlockState state, int flags) {
            boolean set = super.func_180501_a(pos, state, flags);
            if (set && state.func_203425_a(BlockTags.field_200031_h)) {
                this.logs.add(pos);
                this.bounds.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
            }
            return set;
        }

        @Override
        public boolean func_217377_a(BlockPos pos, boolean b) {
            if (super.func_217377_a(pos, b)) {
                this.logs.remove(pos);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_175655_b(BlockPos pos, boolean b) {
            if (super.func_175655_b(pos, b)) {
                this.logs.remove(pos);
                return true;
            }
            return false;
        }

        public boolean func_225521_a_(BlockPos p_225521_1_, boolean p_225521_2_, @Nullable Entity p_225521_3_) {
            return false;
        }

        public BiomeManager func_225523_d_() {
            return null;
        }

        public Biome func_225604_a_(int x, int y, int z) {
            return null;
        }

        public WorldLightManager func_225524_e_() {
            return null;
        }
    }
}

